/*
 * $Header: /home/cvspublic/jakarta-slide/src/stores/org/apache/slide/store/ojb/peer/VersionHistoryPeer.java,v 1.3 2005/01/23 13:57:27 cvillegas Exp $
 * $Revision: 1.3 $
 * $Date: 2005/01/23 13:57:27 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.store.ojb.peer;

import java.io.Serializable;
import java.util.Collection;

/**
 * @ojb.class table="${table.prefix}VERSION_HISTORY"
 * 
 * @ojb.index name="${table.prefix}VERSION_HISTORY_IDX"
 *            unique="true"
 *            fields="uriId,branchId,revisionNumber"
 *
 */
public class VersionHistoryPeer implements Serializable {

    /**
     * @ojb.field column="VERSION_ID"
     *            primarykey="true"
     *            autoincrement="ojb"
     */
    private long versionId;
    
    /**
     * @ojb.field column="URI_ID"
     */
    private long uriId;
    
    /**
     * @ojb.field column="BRANCH_ID"
     */
    private long branchId;
    
    /**
     * @ojb.field column="REVISION_NO"
     *            length="20"
     */
    private String revisionNumber;
    
    /**
     * @ojb.reference foreignkey="uriId"
     */
    private UriPeer uri;
    
    /**
     * @ojb.reference foreignkey="branchId"
     */
    private BranchPeer branch;
    
    /**
     * @ojb.collection element-class-ref="org.apache.slide.store.ojb.peer.VersionPredecessorPeer"
     *                 foreignkey="versionId"
     */
    private Collection predecessors;
    
    /**
     * @ojb.collection element-class-ref="org.apache.slide.store.ojb.peer.VersionLabelPeer"
     *                 foreignkey="versionId"
     */
    private Collection labels;
    
    /**
     * @ojb.collection element-class-ref="org.apache.slide.store.ojb.peer.PropertyPeer"
     *                 foreignkey="versionId"
     */
    private Collection properties;
    
    /**
     * @return Returns the properties.
     */
    public Collection getProperties() {
        return properties;
    }
    /**
     * @param properties The properties to set.
     */
    public void setProperties(Collection properties) {
        this.properties = properties;
    }
    
    /**
     * @return Returns the branch.
     */
    public BranchPeer getBranch() {
        return branch;
    }
    /**
     * @param branch The branch to set.
     */
    public void setBranch(BranchPeer branch) {
        this.branch = branch;
    }
    /**
     * @return Returns the branchId.
     */
    public long getBranchId() {
        return branchId;
    }
    /**
     * @param branchId The branchId to set.
     */
    public void setBranchId(long branchId) {
        this.branchId = branchId;
    }
    /**
     * @return Returns the revisionNumber.
     */
    public String getRevisionNumber() {
        return revisionNumber;
    }
    /**
     * @param revisionNumber The revisionNumber to set.
     */
    public void setRevisionNumber(String revisionNumber) {
        this.revisionNumber = revisionNumber;
    }
    /**
     * @return Returns the uri.
     */
    public UriPeer getUri() {
        return uri;
    }
    /**
     * @param uri The uri to set.
     */
    public void setUri(UriPeer uri) {
        this.uri = uri;
    }
    /**
     * @return Returns the uriId.
     */
    public long getUriId() {
        return uriId;
    }
    /**
     * @param uriId The uriId to set.
     */
    public void setUriId(long uriId) {
        this.uriId = uriId;
    }
    /**
     * @return Returns the versionId.
     */
    public long getVersionId() {
        return versionId;
    }
    /**
     * @param versionId The versionId to set.
     */
    public void setVersionId(long versionId) {
        this.versionId = versionId;
    }
    /**
     * @return Returns the predecessors.
     */
    public Collection getPredecessors() {
        return predecessors;
    }
    /**
     * @param predecessors The predecessors to set.
     */
    public void setPredecessors(Collection predecessors) {
        this.predecessors = predecessors;
    }
    /**
     * @return Returns the labels.
     */
    public Collection getLabels() {
        return labels;
    }
    /**
     * @param labels The labels to set.
     */
    public void setLabels(Collection labels) {
        this.labels = labels;
    }
}
