/*
 * $Header: /home/cvspublic/jakarta-slide/src/stores/org/apache/slide/store/ojb/peer/VersionPredecessorPeer.java,v 1.3 2005/01/23 13:57:27 cvillegas Exp $
 * $Revision: 1.3 $
 * $Date: 2005/01/23 13:57:27 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.store.ojb.peer;

import java.io.Serializable;

/**
 * @ojb.class table="${table.prefix}VERSION_PREDS"
 *
 */
public class VersionPredecessorPeer implements Serializable {
    
    /**
     * @ojb.field column="VERSION_ID"
     *            primarykey="true"
     */
    private long versionId;
    
    /**
     * @ojb.field column="PREDECESSOR_ID"
     *            primarykey="true"
     */
    private long predecessorId;
    
    /**
     * @ojb.reference foreignkey="versionId"
     */
    private VersionHistoryPeer versionHistory;
    
    /**
     * @ojb.reference foreignkey="predecessorId"
     *                auto-retrieve="true"
     */
    private VersionHistoryPeer predecessorVersionHistory;

    
    /**
     * @return Returns the predecessorId.
     */
    public long getPredecessorId() {
        return predecessorId;
    }
    /**
     * @param predecessorId The predecessorId to set.
     */
    public void setPredecessorId(long predecessorId) {
        this.predecessorId = predecessorId;
    }
    /**
     * @return Returns the predecessorVersionHistory.
     */
    public VersionHistoryPeer getPredecessorVersionHistory() {
        return predecessorVersionHistory;
    }
    /**
     * @param predecessorVersionHistory The predecessorVersionHistory to set.
     */
    public void setPredecessorVersionHistory(
            VersionHistoryPeer predecessorVersionHistory) {
        this.predecessorVersionHistory = predecessorVersionHistory;
    }
    /**
     * @return Returns the versionHistory.
     */
    public VersionHistoryPeer getVersionHistory() {
        return versionHistory;
    }
    /**
     * @param versionHistory The versionHistory to set.
     */
    public void setVersionHistory(VersionHistoryPeer versionHistory) {
        this.versionHistory = versionHistory;
    }
    /**
     * @return Returns the versionId.
     */
    public long getVersionId() {
        return versionId;
    }
    /**
     * @param versionId The versionId to set.
     */
    public void setVersionId(long versionId) {
        this.versionId = versionId;
    }
}
