/*
 * $Header: /home/cvspublic/jakarta-slide/src/stores/org/apache/slide/store/ojb/property/DefaultPropertyHandler.java,v 1.1 2005/01/02 20:25:54 ozeigermann Exp $
 * $Revision: 1.1 $
 * $Date: 2005/01/02 20:25:54 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.store.ojb.property;

import org.apache.slide.content.NodeProperty;
import org.apache.slide.store.ojb.peer.PropertyPeer;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;

/**
 * The default PropertyHandler. It simply uses the fields in PropertyPeer.
 */
public class DefaultPropertyHandler implements PropertyHandler {

    public NodeProperty retrieve(PersistenceBroker broker, PropertyPeer propertyPeer)
            throws PropertyHandlerException {
        
        NodeProperty property = new NodeProperty(propertyPeer.getName(),
                propertyPeer.getValue(),
                propertyPeer.getNamespace(),
                propertyPeer.getType(),
                propertyPeer.isPropertyProtected());
        return property;
    }

    public void store(PersistenceBroker broker, PropertyPeer propertyPeer, NodeProperty property)
            throws PropertyHandlerException {
        
        propertyPeer.setNamespace(property.getNamespace());
        propertyPeer.setName(property.getName());
        propertyPeer.setType(property.getType());
        if ( property.getValue() != null )
            propertyPeer.setValue(property.getValue().toString());
        propertyPeer.setPropertyProtected(property.isProtected());
        try {
            broker.store(propertyPeer);
        } catch (PersistenceBrokerException e) {
            throw new PropertyHandlerException("Error storing property " + property.getNamespace() + property.getName(), e);
        }
    }

    public void remove(PersistenceBroker broker, PropertyPeer propertyPeer)
    		throws PropertyHandlerException {
        
        try {
            broker.delete(propertyPeer);
        } catch (PersistenceBrokerException e) {
            throw new PropertyHandlerException("Could not delete property " + 
                    propertyPeer.getNamespace()+ ":" + propertyPeer.getName(), e);
        }
    }
}
