/*
 * $Header: /home/cvspublic/jakarta-slide/src/stores/org/apache/slide/store/ojb/property/PropertyHandler.java,v 1.2 2005/01/23 13:57:27 cvillegas Exp $
 * $Revision: 1.2 $
 * $Date: 2005/01/23 13:57:27 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.store.ojb.property;

import org.apache.ojb.broker.PersistenceBroker;
import org.apache.slide.store.ojb.peer.PropertyPeer;
import org.apache.slide.content.NodeProperty;

/**
 * Handles the persistence of a Property.
 * This allows us to provide different mappings depending on the 
 * property type or other conditions.
 * PropertyHandler's must be reentrant since an instance will be
 * shared for all work.
 */
public interface PropertyHandler {
    
    /**
     * Retrieves the property from the persistence storage.
     * @param propertyPeer the loaded PropertyPeer of the property to retrieve.
     * @return the Slide converted property.
     */
    NodeProperty retrieve(PersistenceBroker broker, PropertyPeer propertyPeer) throws PropertyHandlerException;


    /**
     * Stores the property to the persistence storage.
     * @param propertyPeer PropertyPeer for the property to set. This may be
     *        empty except for the versionId field which must be set. 
     *        The other fields will be filled by the handler as needed.
     * @param property the Slide property to store.
     */
    void store(PersistenceBroker broker, PropertyPeer propertyPeer, NodeProperty property) throws PropertyHandlerException;
    
    /**
     * Removes a property from the persistence storage.
     * @param broker PersistenceBroker
     * @param propertyPeer PropertyPeer to remove.
     */
    void remove(PersistenceBroker broker, PropertyPeer propertyPeer) throws PropertyHandlerException;
}
