/*
 * $Header: /home/cvspublic/jakarta-slide/src/stores/org/apache/slide/store/ojb/property/PropertyHandlerFactory.java,v 1.2 2005/01/23 11:25:59 cvillegas Exp $
 * $Revision: 1.2 $
 * $Date: 2005/01/23 11:25:59 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.store.ojb.property;

import java.util.HashMap;

/**
 * 
 */
public class PropertyHandlerFactory {
    
    private static HashMap handlerMap = new HashMap();
    private static PropertyHandler defaultHandler = new DefaultPropertyHandler();
    private static PropertyHandler elementListHandler = new ElementListPropertyHandler();
    
    private PropertyHandlerFactory() {
        
    }
    
    public static PropertyHandler getPropertyHandler(String namespace, String name) {
        PropertyHandler handler = (PropertyHandler)handlerMap.get(namespace+name);
        if ( handler == null ) {
            if ( "DAV:".equals(namespace) ) {
                if ( "version-set".equals(name) || "checkout-set".equals(name) || 
                     "group-member-set".equals(name) || "privilege-member-set".equals(name) || 
                     "predecessor-set".equals(name) || "label-name-set".equals(name) ) {
                    handler = elementListHandler;
                } else 
                    handler = defaultHandler;
            } else
                handler = defaultHandler;
            handlerMap.put(namespace+name, handler);
        }
        return handler;
    }
    

}
