/*
 * $Header: /home/cvspublic/jakarta-slide/src/webdav/server/org/apache/slide/webdav/event/DetailedWebdavEvent.java,v 1.1 2005/02/25 16:57:28 luetzkendorf Exp $
 * $Revision: 1.1 $
 * $Date: 2005/02/25 16:57:28 $
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.webdav.event;

import java.util.EventListener;
import java.util.EventObject;

import org.apache.slide.event.AbstractEventMethod;
import org.apache.slide.event.VetoException;
import org.apache.slide.event.VetoableEventMethod;

/**
 * Detailed WebDAV events.
 */
public class DetailedWebdavEvent extends EventObject {

    public final static String GROUP = "webdav-detailed";

    public static final MoveBeforeCopy MOVE_BEFORE_COPY = new MoveBeforeCopy();

    public static final MoveAfterCopy MOVE_AFTER_COPY = new MoveAfterCopy();

    public static final MoveBeforeDelete MOVE_BEFORE_DELETE = new MoveBeforeDelete();

    public static final MoveAfterDelete MOVE_AFTER_DELETE = new MoveAfterDelete();
    
    public static final CopyBeforeCopy COPY_BEFORE_COPY = new CopyBeforeCopy();
    
    public static final CopyAfterCopy COPY_AFTER_COPY = new CopyAfterCopy();
    
    public static final CopyBeforeDelete COPY_BEFORE_DELETE = new CopyBeforeDelete();
    
    public static final CopyAfterDelete COPY_AFTER_DELETE = new CopyAfterDelete();
    
    public static final DeleteBeforeDelete DELETE_BEFORE_DELETE = new DeleteBeforeDelete();
    
    public static final DeleteAfterDelete DELETE_AFTER_DELETE = new DeleteAfterDelete();
    
    public static final VersionControlBefore VERSION_CONTROL_BEFORE = new VersionControlBefore();
    
    public static final VersionControlAfter VERSION_CONTROL_AFTER = new VersionControlAfter();

    public final static AbstractEventMethod[] methods = new AbstractEventMethod[] {
            MOVE_BEFORE_COPY, MOVE_AFTER_COPY, MOVE_BEFORE_DELETE,
            MOVE_AFTER_DELETE, DELETE_BEFORE_DELETE, DELETE_AFTER_DELETE,
            VERSION_CONTROL_BEFORE, VERSION_CONTROL_AFTER, COPY_BEFORE_COPY,
            COPY_AFTER_COPY, COPY_BEFORE_DELETE, COPY_AFTER_DELETE};

    private String sourceUri;

    private String destinationUri;

    /**
     *  
     */
    public DetailedWebdavEvent(Object source, String destinationUri) {
        super(source);
        this.destinationUri = destinationUri;
        this.sourceUri = null;
    }

    public DetailedWebdavEvent(Object source, String destinationUri,
            String sourceUri) {
        super(source);
        this.destinationUri = destinationUri;
        this.sourceUri = sourceUri;
    }

    public String getDestinationUri() {
        return destinationUri;
    }

    public String getSourceUri() {
        return sourceUri;
    }

    public final static class MoveBeforeCopy extends VetoableEventMethod {
        public MoveBeforeCopy() {
            super(GROUP, "move-before-copy");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event)
                throws VetoException {
            if (listener instanceof DetailedWebdavListener) {
                ((DetailedWebdavListener) listener).moveBeforeCopy((DetailedWebdavEvent) event);
            }
        }
    }

    public final static class MoveAfterCopy extends VetoableEventMethod {
        public MoveAfterCopy() {
            super(GROUP, "move-after-copy");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event)
                throws VetoException {
            if (listener instanceof DetailedWebdavListener) {
                ((DetailedWebdavListener) listener).moveAfterCopy((DetailedWebdavEvent) event);
            }
        }
    }

    public final static class MoveBeforeDelete extends VetoableEventMethod {
        public MoveBeforeDelete() {
            super(GROUP, "move-before-delete");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event)
                throws VetoException {
            if (listener instanceof DetailedWebdavListener) {
                ((DetailedWebdavListener) listener).moveBeforeDelete((DetailedWebdavEvent) event);
            }
        }
    }

    public final static class MoveAfterDelete extends VetoableEventMethod {
        public MoveAfterDelete() {
            super(GROUP, "move-after-delete");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event)
                throws VetoException {
            if (listener instanceof DetailedWebdavListener) {
                ((DetailedWebdavListener) listener).moveAfterDelete((DetailedWebdavEvent) event);
            }
        }
    }
    
    public final static class CopyBeforeCopy extends VetoableEventMethod {
        public CopyBeforeCopy() {
            super(GROUP, "copy-before-copy");
        }
        
        public void fireVetaoableEvent(EventListener listener, EventObject event)
                throws VetoException {
            if (listener instanceof DetailedWebdavListener) {
                ((DetailedWebdavListener) listener).copyBeforeCopy((DetailedWebdavEvent) event);
            }
        }
    }

    public final static class CopyAfterCopy extends VetoableEventMethod {
        public CopyAfterCopy() {
            super(GROUP, "copy-after-copy");
        }
        
        public void fireVetaoableEvent(EventListener listener, EventObject event)
                throws VetoException {
            if (listener instanceof DetailedWebdavListener) {
                ((DetailedWebdavListener) listener).copyAfterCopy((DetailedWebdavEvent) event);
            }
        }
    }
    
    public final static class CopyBeforeDelete extends VetoableEventMethod {
        public CopyBeforeDelete() {
            super(GROUP, "copy-before-delete");
        }
        
        public void fireVetaoableEvent(EventListener listener, EventObject event)
                throws VetoException {
            if (listener instanceof DetailedWebdavListener) {
                ((DetailedWebdavListener) listener).copyBeforeDelete((DetailedWebdavEvent) event);
            }
        }
    }
    
    public final static class CopyAfterDelete extends VetoableEventMethod {
        public CopyAfterDelete() {
            super(GROUP, "copy-after-delete");
        }
        
        public void fireVetaoableEvent(EventListener listener, EventObject event)
                throws VetoException {
            if (listener instanceof DetailedWebdavListener) {
                ((DetailedWebdavListener) listener).copyAfterDelete((DetailedWebdavEvent) event);
            }
        }
    }
    
    public static final class DeleteBeforeDelete extends VetoableEventMethod {
        public DeleteBeforeDelete() {
            super(GROUP, "delete-before-delete");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event)
                throws VetoException {
            if (listener instanceof DetailedWebdavListener) {
                ((DetailedWebdavListener) listener).deleteBeforeDelete((DetailedWebdavEvent) event);
            }
        }
    }
    
    public static final class DeleteAfterDelete extends VetoableEventMethod {
        public DeleteAfterDelete() {
            super(GROUP, "delete-after-delete");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event)
                throws VetoException {
            if (listener instanceof DetailedWebdavListener) {
                ((DetailedWebdavListener) listener).deleteAfterDelete((DetailedWebdavEvent) event);
            }
        }
    }
    
    public static final class VersionControlBefore extends VetoableEventMethod {
        public VersionControlBefore() {
            super(GROUP, "version-control-before");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event)
                throws VetoException {
            if (listener instanceof DetailedWebdavListener) {
                ((DetailedWebdavListener) listener).versionControlBefore((DetailedWebdavEvent) event);
            }
        }
    }
    
    public static final class VersionControlAfter extends VetoableEventMethod {
        public VersionControlAfter() {
            super(GROUP, "version-control-after");
        }

        public void fireVetaoableEvent(EventListener listener, EventObject event)
                throws VetoException {
            if (listener instanceof DetailedWebdavListener) {
                ((DetailedWebdavListener) listener).versionControlAfter((DetailedWebdavEvent) event);
            }
        }
    }
}