/*
 * $Header: /home/cvspublic/jakarta-slide/src/webdav/server/org/apache/slide/webdav/method/HeadMethod.java,v 1.9 2004/07/28 09:32:17 ib Exp $
 * $Revision: 1.9 $
 * $Date: 2004/07/28 09:32:17 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */ 

package org.apache.slide.webdav.method;

import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.webdav.WebdavServletConfig;

/**
 * HEAD method.
 * 
 */
public class HeadMethod extends GetMethod {
    
    
    // ----------------------------------------------------------- Constructors
    
    
    /**
     * Constructor.
     * 
     * @param token     the token for accessing the namespace
     * @param config    configuration of the WebDAV servlet
     */
    public HeadMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
        
        printContent = false;
    }
    
    
}

