/*
 * $Header: /home/cvspublic/jakarta-slide/src/webdav/server/org/apache/slide/webdav/util/PathMapper.java,v 1.1 2005/02/09 19:14:38 ozeigermann Exp $
 * $Revision: 1.1 $
 * $Date: 2005/02/09 19:14:38 $
 *
 * ====================================================================
 *
 * Copyright 2005 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.webdav.util;

import javax.servlet.http.HttpServletRequest;

import org.apache.slide.webdav.WebdavServletConfig;

/**
 * Interface for a mapper hook from an HttpServletRequest to the path passed to the Slide core.
 * Is used by 
 * {@link org.apache.slide.webdav.util.WebdavUtils#getRelativePath(HttpServletRequest, WebdavServletConfig)}
 * and can either be configured in web.xml by setting its implementing class 
 * using initial parameter <em>path-mapper-hook</em>
 * or by setting attribute <em>org.apache.slide.webdav.util.PathMapper</em> in the servlet context
 * to an instance of this interface.<br>
 * <br>
 * This hook can also be used to pass information to the store level.
 * 
 * @see org.apache.slide.webdav.util.WebdavUtils#getRelativePath(HttpServletRequest, WebdavServletConfig)
 */
public interface PathMapper {

    /**
     * Maps the request URI of a HTTP request to a path used in the core and store layer.
     * (this does not necessarily mean that a node exists at that URI).
     * 
     * @param req the request object
     * @param config configuration of the WebdavServlet
     *
     * @return the mapped request URI
     */
    String map(HttpServletRequest req, WebdavServletConfig config);
}