// vi: set ts=3 sw=3:
package org.apache.slide.webdav.util;

import org.apache.slide.common.SlideToken;
import org.apache.slide.webdav.WebdavServletConfig;


/**
 * @author Stefan Ltzkendorf
 */
public interface WebdavContext
{
    /**
     * The token identifying the current acting principal.
     */
    public SlideToken getSlideToken();

    /**
     * The configuration of the WebDAV Servlet. 
     */
    public WebdavServletConfig getServletConfig();
    
    /**
     * The complete context path that prefixes each URI of the current 
     * namespace.  
     */
    public String getContextPath(); 
}
