// vi: set ts=3 sw=3:
package org.apache.slide.webdav.util;

import org.apache.slide.common.SlideToken;
import org.apache.slide.webdav.WebdavServletConfig;


/**
 * @author Stefan Ltzkendorf
 */
public class WebdavContextImpl implements WebdavContext
{
    private String contextPath;
    private WebdavServletConfig servletConfig;
    private SlideToken slideToken;
    
    public static WebdavContext create(SlideToken token, 
            WebdavServletConfig servletConfig, String contextPath) 
    {
        WebdavContextImpl instance = new WebdavContextImpl();
        instance.contextPath = contextPath;
        instance.servletConfig = servletConfig;
        instance.slideToken = token;
        return instance;
    }
    
    protected WebdavContextImpl() {
        
    }
    
    public String getContextPath()
    {
        return this.contextPath;
    }
    public WebdavServletConfig getServletConfig()
    {
        return this.servletConfig;
    }
    public SlideToken getSlideToken()
    {
        return this.slideToken;
    }
}
