package org.apache.slide.webdav.util;

import java.util.HashSet;
import java.util.Set;

import org.apache.slide.util.Configuration;


/**
 * Helper class for managing features suported by slide.
 */
public class WebdavFeatures
{
    private static Set supportedFeatures = new HashSet();
    
    /**
     * Tests whether a given feature is supported.
     */
   public static boolean isSupported(String feature) {
       return supportedFeatures.contains(feature);
   }
    
    // static initialization
    static {
        // features
        supportedFeatures.add(WebdavConstants.F_WEBDAV);
        supportedFeatures.add(WebdavConstants.F_SLIDE);
        
        if(Configuration.useIntegratedLocking()) {
            supportedFeatures.add(WebdavConstants.F_LOCKING);
        }
        if(Configuration.useIntegratedSecurity()) {
            supportedFeatures.add(AclConstants.F_ACCESS_CONTROL);
        }
        if(Configuration.useSearch()) {
            supportedFeatures.add(DaslConstants.F_SEARCHING_AND_LOCATING);
        }
        if(Configuration.useVersionControl()) {
            supportedFeatures.add(DeltavConstants.F_VERSION_CONTROL);
            supportedFeatures.add(DeltavConstants.F_VERSION_HISTORY);
            supportedFeatures.add(DeltavConstants.F_CHECKOUT_IN_PLACE);
            supportedFeatures.add(DeltavConstants.F_WORKSPACE);
            supportedFeatures.add(DeltavConstants.F_WORKING_RESOURCE);
            supportedFeatures.add(DeltavConstants.F_LABEL);
            supportedFeatures.add(DeltavConstants.F_UPDATE);
        }
        if (Configuration.useGlobalBinding()) {
            supportedFeatures.add(BindConstants.F_BINDING);
        }
        if (Configuration.useRedirectReferences()) {
            supportedFeatures.add(WebdavConstants.F_REDIRECTREFS);
        }
    }
}
