/*
 * $Header: /home/cvspublic/jakarta-slide/src/webdav/server/org/apache/slide/webdav/util/properties/AbstractComputedProperty.java,v 1.1 2004/12/29 16:33:54 luetzkendorf Exp $
 * $Revision: 1.1 $
 * $Date: 2004/12/29 16:33:54 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.webdav.util.properties;

import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.NamespaceConfig;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeProperty.NamespaceCache;
import org.apache.slide.util.XMLValue;
import org.apache.slide.webdav.util.AclConstants;
import org.jdom.Element;
import org.jdom.Namespace;

/**
 * Base class for computed properties with some common helpers.
 */
public abstract class AbstractComputedProperty 
    implements PropertyComputer
{
    
    protected static final Namespace DNSP = NamespaceCache.DEFAULT_NAMESPACE;

    
    /**
     * Any leading <code>/</code> in the given <code>uri</code> will be removed.
     *
     * @param      uri  the Uri to remove leading slashes from.
     *
     * @return     the Uri without leading slashes.
     */
    protected static String truncateLeadingSlash(String uri) {
        
        if (uri == null) {
            return uri;
        }
        
        while (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        return uri;
    }
    
    protected XMLValue createUserPath(NamespaceAccessToken nsaToken,
            NodeProperty userProperty, 
            String slideContextPath) 
    {
        XMLValue xmlValue = new XMLValue();
        // TODO use StringBuffer
        String userHref = "";
        NamespaceConfig config = nsaToken.getNamespaceConfig();
        if ((userProperty != null) && (userProperty.getValue() != null)
                && (!"".equals(userProperty.getValue().toString()))) {

            userHref = slideContextPath + config.getUsersPath() + "/"
                    + userProperty.getValue().toString();
            xmlValue.addHref(userHref);
        } else {
            xmlValue.add(new Element(AclConstants.E_UNAUTHENTICATED, 
                    NamespaceCache.DEFAULT_NAMESPACE));
        }
        return xmlValue;
    }
}
