/*
 * $Header: /home/cvspublic/jakarta-slide/src/webdav/server/org/apache/slide/webdav/util/properties/AclRestrictionsProperty.java,v 1.4 2005/01/03 15:04:44 luetzkendorf Exp $
 * $Revision: 1.4 $
 * $Date: 2005/01/03 15:04:44 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.webdav.util.properties;

import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyName;
import org.apache.slide.common.PropertyParseException;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.util.XMLValue;
import org.apache.slide.webdav.util.AclConstants;
import org.apache.slide.webdav.util.WebdavContext;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.jdom.JDOMException;


/**
 * Computes the ACL <code>acl-restrictions</code> property.
 */
public class AclRestrictionsProperty extends AbstractComputedProperty
{
    public PropertyName getPropertyName() {
        return AclConstants.PN_ACL_RESTRICTIONS;
    }

    public Object computeValue(
            NamespaceAccessToken nsaToken,
            NodeRevisionDescriptors revisionDescriptors, 
            NodeRevisionDescriptor revisionDescriptor, 
            ResourceKind resourceKind, WebdavContext context)
        throws PropertyParseException
    {
        // no restrictions in Slide implementation?
        if (revisionDescriptor.exists(AclConstants.PN_ACL_RESTRICTIONS)) {
            Object v = revisionDescriptor.getProperty(AclConstants.PN_ACL_RESTRICTIONS).getValue();
            try {
                return (v instanceof XMLValue)
                    ? (XMLValue)v
                    : new XMLValue((String)v);
            } catch (JDOMException e) {
                throw new PropertyParseException(
                        "Can't parse " + AclConstants.P_ACL_RESTRICTIONS, e);
            }
        }
        else {
            return new XMLValue();
        }
    }

}
