/*
 * $Header: /home/cvspublic/jakarta-slide/src/webdav/server/org/apache/slide/webdav/util/properties/CheckinForkProperty.java,v 1.1 2005/01/03 15:04:44 luetzkendorf Exp $
 * $Revision: 1.1 $
 * $Date: 2005/01/03 15:04:44 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.webdav.util.properties;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.apache.slide.common.Domain;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyName;
import org.apache.slide.common.SlideToken;
import org.apache.slide.util.XMLValue;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.jdom.Element;

/**
 * Validator for DeltaV <code>checkin-fork</code> property.
 */
public class CheckinForkProperty extends AbstractOptionValidator
    implements PropertyDefaultProvider
{
    private static Set allowedValues = new HashSet();
    static {
        allowedValues.add(DeltavConstants.E_DISCOURAGED); 
        allowedValues.add(DeltavConstants.E_FORBIDDEN); 
        
        allowedValues = Collections.unmodifiableSet(allowedValues);
    }

    public PropertyName getPropertyName() {
        return DeltavConstants.PN_CHECKIN_FORK;
    }

    protected Set getAllowedValues()
    {
        return allowedValues;
    }

    protected boolean allowsEmptyValue()
    {
        return true;
    }
    
    public Object createDefaultValue(NamespaceAccessToken accessToken,
            SlideToken slideToken, ResourceKind resourceKind,
            String resourcePath)
    {
        XMLValue value = new XMLValue();
        
        String checkinFork = Domain.getParameter(
                    DeltavConstants.I_CHECKIN_FORK,
                    DeltavConstants.I_CHECKIN_FORK_DEFAULT,
                    accessToken.getUri(slideToken, resourcePath).getStore());
        
        if (checkinFork.length() > 0) {
            if (!allowedValues.contains(checkinFork)) {
                Domain.warn("checkin-fork not configured properly; using "
                        +DeltavConstants.I_CHECKIN_FORK_DEFAULT );
                checkinFork = DeltavConstants.I_CHECKIN_FORK_DEFAULT;
            }
            
            value.add(new Element(checkinFork, "DAV:"));
        }
        
        return value;
    }
}
