// vi: set ts=3 sw=3:
package org.apache.slide.webdav.util.properties;

import org.apache.slide.authenticate.CredentialsToken;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyName;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.WebdavContext;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;


/**
 * Deltav property <code>creator-displayname</code>.
 */
public class CreatorDisplaynameProperty extends AbstractComputedProperty
        implements PropertyDefaultProvider
{

    /* 
     * @see org.apache.slide.webdav.util.properties.PropertyComputer#getPropertyName()
     */
    public PropertyName getPropertyName()
    {
        return DeltavConstants.PN_CREATOR_DISPLAYNAME;
    }

    /* 
     * @see org.apache.slide.webdav.util.properties.PropertyDefaultProvider#createDefaultValue(org.apache.slide.common.NamespaceAccessToken, org.apache.slide.common.SlideToken, org.apache.slide.webdav.util.resourcekind.ResourceKind, java.lang.String)
     */
    public Object createDefaultValue(NamespaceAccessToken accessToken,
            SlideToken slideToken, ResourceKind resourceKind,
            String resourcePath)
    {
        CredentialsToken credToken = slideToken.getCredentialsToken();
        String result = null;
        
        if(credToken != null) {
            result = credToken.getPublicCredentials();
        }
        if (result == null || result.equals("") || result.equals("/")) {
            result = SubjectNode.UNAUTHENTICATED_URI;
        }
        
        return result;
    }

    /* 
     * @see org.apache.slide.webdav.util.properties.PropertyComputer#computeValue(org.apache.slide.common.NamespaceAccessToken, org.apache.slide.content.NodeRevisionDescriptors, org.apache.slide.content.NodeRevisionDescriptor, org.apache.slide.webdav.util.resourcekind.ResourceKind, org.apache.slide.webdav.util.WebdavContext)
     */
    public Object computeValue(NamespaceAccessToken nsaToken,
            NodeRevisionDescriptors revisionDescriptors,
            NodeRevisionDescriptor revisionDescriptor,
            ResourceKind resourceKind, WebdavContext context)
            throws SlideException
    {
        // TODO
        return null;
    }

}
