package org.apache.slide.webdav.util.properties;

import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyName;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.util.conf.Configuration;
import org.apache.slide.util.conf.ConfigurationException;
import org.apache.slide.webdav.util.WebdavContext;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;

/**
 * Computed property that looks for the property at the given resource, 
 * if the resource has no such property the default value is returned.
 */
public class DefaultedProperty extends AbstractComputedProperty implements
        ConfigurablePropertyComputer {

    private PropertyName propertyName;
    private String defaultValue;
    
    /* (non-Javadoc)
     * @see org.apache.slide.webdav.util.properties.ConfigurablePropertyComputer#setPropertyName(org.apache.slide.common.PropertyName)
     */
    public void setPropertyName(PropertyName propertyName) {
        this.propertyName = propertyName;
    }

    /* (non-Javadoc)
     * @see org.apache.slide.webdav.util.properties.PropertyComputer#getPropertyName()
     */
    public PropertyName getPropertyName() {
        return this.propertyName;
    }

    /* (non-Javadoc)
     * @see org.apache.slide.webdav.util.properties.PropertyComputer#computeValue(org.apache.slide.common.NamespaceAccessToken, org.apache.slide.content.NodeRevisionDescriptors, org.apache.slide.content.NodeRevisionDescriptor, org.apache.slide.webdav.util.resourcekind.ResourceKind, org.apache.slide.webdav.util.WebdavContext)
     */
    public Object computeValue(NamespaceAccessToken nsaToken,
            NodeRevisionDescriptors revisionDescriptors,
            NodeRevisionDescriptor revisionDescriptor,
            ResourceKind resourceKind, WebdavContext context)
            throws SlideException {
        
        Object value = revisionDescriptor.getProperty(this.propertyName);
        if (value != null) {
            return value; 
        } else {
            return this.defaultValue;
        }
    }

    public void configure(Configuration configuration)
            throws ConfigurationException {
        try {
            Configuration c = configuration.getConfiguration("default-value");
            this.defaultValue = c.getValue("");
        } catch (ConfigurationException e) {
            // ignore; no default-value given; is ok too
        }
    }

}
