/*
 * $Header: /home/cvspublic/jakarta-slide/src/webdav/server/org/apache/slide/webdav/util/properties/GetContentLanguageProperty.java,v 1.1 2005/01/03 15:04:44 luetzkendorf Exp $
 * $Revision: 1.1 $
 * $Date: 2005/01/03 15:04:44 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.webdav.util.properties;

import java.util.StringTokenizer;

import org.apache.slide.common.PropertyName;
import org.apache.slide.webdav.util.WebdavConstants;


/**
 * DAV <code>getcontentlanguage</code> property.
 */
public class GetContentLanguageProperty implements PropertyValueValidator
{

    public PropertyName getPropertyName()
    {
        return WebdavConstants.PN_GETCONTENTLANGUAGE;
    }

    /* 
     * @see org.apache.slide.webdav.util.properties.PropertyValueValidator#checkPropertyValue(java.lang.Object)
     */
    public void checkPropertyValue(Object value)
            throws InvalidLivePropertyValueException
    {
        // language-tag      = primary-tag *( "-" subtag )
        // primary-tag       = 1*8ALPHA
        // subtag            = 1*8ALPHA
        // Content-Language  = "Content-Language" ":" 1#language-tag

        if (!(value instanceof String)) {
            throw new InvalidLivePropertyValueException();
        }
        
        StringTokenizer tokenizer = new StringTokenizer(value.toString(), ", ");
        for(; tokenizer.hasMoreTokens();) {
            String langTag = tokenizer.nextToken();
            
            StringTokenizer sub = new StringTokenizer(langTag, "-");
            for(;sub.hasMoreTokens();) {
                String subTag = sub.nextToken();
                if (subTag.length() > 8) {
                    throw new InvalidLivePropertyValueException();
                }
            }
        }
    }
}
