/*
 * $Header: /home/cvspublic/jakarta-slide/src/webdav/server/org/apache/slide/webdav/util/properties/GroupMembershipProperty.java,v 1.3 2005/01/03 15:04:44 luetzkendorf Exp $
 * $Revision: 1.3 $
 * $Date: 2005/01/03 15:04:44 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.webdav.util.properties;

import java.util.Enumeration;

import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyName;
import org.apache.slide.common.PropertyParseException;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.security.ACLSecurityImpl;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.util.XMLValue;
import org.apache.slide.webdav.util.AclConstants;
import org.apache.slide.webdav.util.WebdavContext;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.jdom.JDOMException;


/**
 * Computes the ACL <code>group-membership</code> property.
 */
public class GroupMembershipProperty extends AbstractComputedProperty
{
    public PropertyName getPropertyName() {
        return AclConstants.PN_GROUP_MEMBERSHIP;
    }
    
    public Object computeValue(NamespaceAccessToken nsaToken,
            NodeRevisionDescriptors revisionDescriptors,
            NodeRevisionDescriptor revisionDescriptor, ResourceKind resourceKind, WebdavContext context)
            throws SlideException
    {
        if (revisionDescriptor.exists(AclConstants.PN_GROUP_MEMBERSHIP)) {
            Object v = revisionDescriptor.getProperty(
                    AclConstants.PN_GROUP_MEMBERSHIP).getValue();
            try {
                return (v instanceof XMLValue)
                    ? (XMLValue)v
                    : new XMLValue((String)v);
            } catch (JDOMException e) {
                throw new PropertyParseException("Can't parse " + 
                        AclConstants.PN_GROUP_MEMBERSHIP, e);
            }
        }
        else {
            XMLValue xmlValue = new XMLValue();
            Uri principalUri = nsaToken.getUri(context.getSlideToken(), 
                    revisionDescriptors.getUri());
            SubjectNode principalNode = (SubjectNode)principalUri.getStore().retrieveObject(principalUri);
            Enumeration roles = ((ACLSecurityImpl)nsaToken.getSecurityHelper())
                    .getGroupMembership(context.getSlideToken(), principalNode);
            while (roles.hasMoreElements()) {
                String rolePath = (String)roles.nextElement();
                String roleHref = context.getContextPath()+rolePath;
                xmlValue.addHref(roleHref);
            }
            return xmlValue;
        }
    }
}
