/*
 * $Header: /home/cvspublic/jakarta-slide/src/webdav/server/org/apache/slide/webdav/util/properties/PropertyValueValidator.java,v 1.2 2005/01/03 15:04:44 luetzkendorf Exp $
 * $Revision: 1.2 $
 * $Date: 2005/01/03 15:04:44 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.webdav.util.properties;

import org.apache.slide.common.PropertyName;


/**
 * Interface for objects that validate values of a WebDAV property.
 */
public interface PropertyValueValidator
{
    public PropertyName getPropertyName();
    
    public void checkPropertyValue(Object value) 
            throws InvalidLivePropertyValueException;
}
