/*
 * $Header: /home/cvspublic/jakarta-slide/src/webdav/server/org/apache/slide/webdav/util/properties/RootVersionProperty.java,v 1.4 2005/01/10 18:09:22 luetzkendorf Exp $
 * $Revision: 1.4 $
 * $Date: 2005/01/10 18:09:22 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.webdav.util.properties;

import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyName;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.util.XMLValue;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.WebdavContext;
import org.apache.slide.webdav.util.WebdavUtils;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.apache.slide.webdav.util.resourcekind.VersionHistory;
import org.jdom.Element;


/**
 * Computes the DeltaV <code>root-version</code> property.
 * <p>
 * Returns an XMLValue containing the <code>&lt;href&gt;</code> element
 * with the URI of the root version of the history.
 * If the resource is not a history, the returned XMLValue is empty.
 */
public class RootVersionProperty extends AbstractComputedProperty
{
    public PropertyName getPropertyName() {
        return DeltavConstants.PN_ROOT_VERSION;
    }

    public Object computeValue(NamespaceAccessToken nsaToken,
            NodeRevisionDescriptors revisionDescriptors,
            NodeRevisionDescriptor revisionDescriptor, 
            ResourceKind resourceKind, 
            WebdavContext context)
            throws SlideException
    {
        XMLValue xmlValue = new XMLValue();
        
        if (resourceKind instanceof VersionHistory) {
            Element element = new Element(DeltavConstants.E_HREF, 
                    DNSP);
            StringBuffer buffer = new StringBuffer(revisionDescriptors.getUri());
            if ( ! revisionDescriptors.getUri().endsWith("/") ) {
                buffer.append("/");
            }
            buffer.append(revisionDescriptors.getInitialRevision().toString());
            
            element.setText(WebdavUtils.getAbsolutePath(
                                buffer.toString(), context));
            
            xmlValue.add(element);
        }
        
        return xmlValue;
    }

}
