/*
 * $Header: /home/cvspublic/jakarta-slide/src/webdav/server/org/apache/slide/webdav/util/properties/SimpleDefaultProvider.java,v 1.1 2005/01/03 15:04:44 luetzkendorf Exp $
 * $Revision: 1.1 $
 * $Date: 2005/01/03 15:04:44 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.webdav.util.properties;

import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyName;
import org.apache.slide.common.SlideToken;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;


/**
 * Implementation of {@link PropertyDefaultProvider} that simply returns a 
 * constant value.
 */
public class SimpleDefaultProvider implements PropertyDefaultProvider
{
    private String defaultValue;
    private PropertyName propertyName;
    
    /**
     * Constructor.
     * @param name Name of the property for that the default value is provided.
     * @param value The default value of the property.
     */
    public SimpleDefaultProvider(PropertyName name, String value) {
        this.propertyName = name;
        this.defaultValue = value;
    }

    public PropertyName getPropertyName()
    {
        return this.propertyName;
    }

    public Object createDefaultValue(NamespaceAccessToken accessToken,
            SlideToken slideToken, ResourceKind resourceKind,
            String resourcePath)
    {
        return this.defaultValue;
    }
}
