/*
 * $Header: /home/cvspublic/jakarta-slide/src/webdav/server/org/apache/slide/webdav/util/properties/SuccessorSetProperty.java,v 1.4 2005/01/19 15:17:43 luetzkendorf Exp $
 * $Revision: 1.4 $
 * $Date: 2005/01/19 15:17:43 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.webdav.util.properties;

import java.util.Enumeration;

import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyName;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.util.XMLValue;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.WebdavContext;
import org.apache.slide.webdav.util.WebdavUtils;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.jdom.Element;


/**
 * Computes the DeltaV <code>successor-set</code> property.
 */
public class SuccessorSetProperty extends AbstractComputedProperty
{
    public PropertyName getPropertyName() {
        return DeltavConstants.PN_SUCCESSOR_SET;
    }

    public Object computeValue(NamespaceAccessToken nsaToken,
            NodeRevisionDescriptors revisionDescriptors,
            NodeRevisionDescriptor revisionDescriptor, ResourceKind resourceKind, WebdavContext context)
            throws SlideException
    {
        XMLValue xmlValue = new XMLValue();
        Element hrefElement = new Element(DeltavConstants.E_HREF, DNSP);
        //NodeRevisionDescriptor successorRevisionDescriptor = null;
        NodeRevisionNumber successorRevisionNumber = null;
        Enumeration successorEnum = revisionDescriptors.getSuccessors(
                revisionDescriptor.getRevisionNumber());
        
        while (successorEnum.hasMoreElements()) {
            successorRevisionNumber = (NodeRevisionNumber)successorEnum.nextElement();
            hrefElement = (Element)hrefElement.clone();
            StringBuffer buffer = new StringBuffer(revisionDescriptors.getUri());
            if ( ! revisionDescriptors.getUri().endsWith("/") ) {
                buffer.append("/");
            }
            buffer.append(successorRevisionNumber.toString());
            
            hrefElement.setText(WebdavUtils.getAbsolutePath (
                                    buffer.toString(), 
                                    context));
            
            xmlValue.add(hrefElement);
            }
        return xmlValue;
    }
}
