/*
 * $Header: /home/cvspublic/jakarta-slide/src/webdav/server/org/apache/slide/webdav/util/properties/SupportedLivePropertySetProperty.java,v 1.4 2005/01/10 18:09:22 luetzkendorf Exp $
 * $Revision: 1.4 $
 * $Date: 2005/01/10 18:09:22 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.webdav.util.properties;

import java.util.Iterator;
import java.util.Set;

import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyName;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.util.XMLValue;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.WebdavContext;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.jdom.Element;


/**
 * Computes the DeltaV <code>supported-live-property-set</code> property.
 * 
 * Returns an XMLValue containing the <code>&lt;supported-live-property&gt;</code>
 * elements containing <code>&lt;prop&gt;</code> which are containing
 * elements with the name of the property.
 * 
 * <p><i>Note:</i>
 * Due to the specification this is <b>not</b> a computed property, but because
 * of implementation problems it is not stored.
 */
public class SupportedLivePropertySetProperty extends
        AbstractComputedProperty
{
 
    public PropertyName getPropertyName() {
        return DeltavConstants.PN_SUPPORTED_LIVE_PROPERTY_SET;
    }

    public Object computeValue(NamespaceAccessToken nsaToken,
            NodeRevisionDescriptors revisionDescriptors,
            NodeRevisionDescriptor revisionDescriptor, 
            ResourceKind resourceKind, 
            WebdavContext context)
            throws SlideException
    {
        XMLValue xmlValue = new XMLValue();
        
        Set supportedLivePropertyNames = resourceKind.getSupportedLiveProperties();
        Iterator iterator = supportedLivePropertyNames.iterator();
        Element supportedLivePropertyElement = null;
        Element propElement = null;
        Element propertyElement = null;
        while (iterator.hasNext()) {
            
            supportedLivePropertyElement = new Element(
                    DeltavConstants.E_SUPPORTED_LIVE_PROPERTY, DNSP);
            propElement = new Element(DeltavConstants.E_PROP, DNSP);
            supportedLivePropertyElement.addContent(propElement);
            propertyElement = new Element((String)iterator.next(), DNSP);
            propElement.addContent(propertyElement);
            xmlValue.add(supportedLivePropertyElement);
        }
        
        return xmlValue;
    }

}
