/*
 * $Header: /home/cvspublic/jakarta-slide/src/webdav/server/org/apache/slide/webdav/util/properties/SupportedLockProperty.java,v 1.2 2005/01/03 15:04:44 luetzkendorf Exp $
 * $Revision: 1.2 $
 * $Date: 2005/01/03 15:04:44 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.webdav.util.properties;

import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyName;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.util.XMLValue;
import org.apache.slide.webdav.util.AclConstants;
import org.apache.slide.webdav.util.WebdavConstants;
import org.apache.slide.webdav.util.WebdavContext;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.jdom.Element;


/**
 * Computes the WebDAV <code>supportedlock</code> property.
 */
public class SupportedLockProperty extends AbstractComputedProperty
{
    public PropertyName getPropertyName() {
        return AclConstants.PN_SUPPORTEDLOCK;
    }
    
    public Object computeValue(NamespaceAccessToken nsaToken,
            NodeRevisionDescriptors revisionDescriptors,
            NodeRevisionDescriptor revisionDescriptor, 
            ResourceKind resourceKind, 
            WebdavContext context)
            throws SlideException
    {
        // TODO this returns a constant value, reuse it
        
        XMLValue xmlValue = new XMLValue();
        
        Element lockentry = new Element(WebdavConstants.E_LOCKENTRY, DNSP);
        Element lockscope = new Element(WebdavConstants.E_LOCKSCOPE, DNSP);
        lockentry.addContent(lockscope);
        Element exclusive = new Element(WebdavConstants.E_EXCLUSIVE, DNSP);
        lockscope.addContent(exclusive);
        Element locktype = new Element(WebdavConstants.E_LOCKTYPE, DNSP);
        lockentry.addContent(locktype);
        Element write = new Element(WebdavConstants.E_WRITE, DNSP);
        locktype.addContent(write);
        xmlValue.add(lockentry);
        
        lockentry = new Element(WebdavConstants.E_LOCKENTRY, DNSP);
        lockscope = new Element(WebdavConstants.E_LOCKSCOPE, DNSP);
        lockentry.addContent(lockscope);
        Element shared = new Element(WebdavConstants.E_SHARED, DNSP);
        lockscope.addContent(shared);
        locktype = new Element(WebdavConstants.E_LOCKTYPE, DNSP);
        lockentry.addContent(locktype);
        write = new Element(WebdavConstants.E_WRITE, DNSP);
        locktype.addContent(write);
        xmlValue.add(lockentry);
        
        return xmlValue;
    }

}
