/*
 * $Header: /home/cvspublic/jakarta-slide/src/webdav/server/org/apache/slide/webdav/util/properties/SupportedReportSetProperty.java,v 1.4 2005/01/10 18:09:22 luetzkendorf Exp $
 * $Revision: 1.4 $
 * $Date: 2005/01/10 18:09:22 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.webdav.util.properties;

import java.util.Iterator;

import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyName;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.util.XMLValue;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.WebdavContext;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.jdom.Element;


/**
 * Computes the DeltaV <code>supported-report-set</code> property.
 * 
 * <p>Returns an XMLValue containing the <code>&lt;supported-report&gt;</code>
 * elements containing <code>&lt;report&gt;</code> which are containing
 * elements with the name of the report.
 * <p><i>Note:</i>
 * Due to the specification this is <b>not</b> a computed property, but because
 * of implementation problems it is not stored.
 */
public class SupportedReportSetProperty extends
        AbstractComputedProperty
{
    public PropertyName getPropertyName() {
        return DeltavConstants.PN_SUPPORTED_REPORT_SET;
    }

    public Object computeValue(NamespaceAccessToken nsaToken,
            NodeRevisionDescriptors revisionDescriptors,
            NodeRevisionDescriptor revisionDescriptor, ResourceKind resourceKind, WebdavContext context)
            throws SlideException
    {
        XMLValue xmlValue = new XMLValue();
        
        Iterator iterator = resourceKind.getSupportedReports().iterator();
        Element supportedReportElement = null;
        Element reportElement = null;
        Element propertyElement = null;
        while (iterator.hasNext()) {
            supportedReportElement = new Element(
                    DeltavConstants.E_SUPPORTED_REPORT, DNSP);
            reportElement = new Element(DeltavConstants.E_REPORT, DNSP);
            supportedReportElement.addContent(reportElement);
            propertyElement = new Element((String)iterator.next(), DNSP);
            reportElement.addContent(propertyElement);
            xmlValue.add(supportedReportElement);
        }
        
        return xmlValue;
    }

}
