/*
 * $Header: /home/cvspublic/jakarta-slide/src/webdav/server/org/apache/slide/webdav/util/properties/VersionHistoryProperty.java,v 1.4 2005/01/10 18:09:22 luetzkendorf Exp $
 * $Revision: 1.4 $
 * $Date: 2005/01/10 18:09:22 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.webdav.util.properties;

import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyName;
import org.apache.slide.common.PropertyParseException;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.util.XMLValue;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.UriHandler;
import org.apache.slide.webdav.util.WebdavContext;
import org.apache.slide.webdav.util.WebdavUtils;
import org.apache.slide.webdav.util.resourcekind.CheckedInVersionControlled;
import org.apache.slide.webdav.util.resourcekind.CheckedOutVersionControlled;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.apache.slide.webdav.util.resourcekind.Version;
import org.jdom.Element;
import org.jdom.JDOMException;


/**
 * Computes the DeltaV <code>version-history</code> property.
 * 
 * <p>Returns an XMLValue containing the <code>&lt;href&gt;</code> element
 * with the history URI of the resource. If the resource is neither a
 * VR, checked-in VCR or checked-out VCR, the returned XMLValue is empty.
 */
public class VersionHistoryProperty extends AbstractComputedProperty
{
    public PropertyName getPropertyName() {
        return DeltavConstants.PN_VERSION_HISTORY;
    }

    public Object computeValue(NamespaceAccessToken nsaToken,
            NodeRevisionDescriptors revisionDescriptors,
            NodeRevisionDescriptor revisionDescriptor, ResourceKind resourceKind, WebdavContext context)
            throws SlideException
    {
        XMLValue xmlValue = new XMLValue();
        try {
            if (resourceKind instanceof Version) {
                Element element = new Element(DeltavConstants.E_HREF, DNSP);
                
                element.setText(WebdavUtils.getAbsolutePath (
                                    revisionDescriptors.getUri(), context));
                
                xmlValue.add(element);
            }
            else if (resourceKind instanceof CheckedInVersionControlled) {
                Element element = new Element(DeltavConstants.E_HREF, DNSP);
                String checkedInHref = revisionDescriptor.getProperty(
                        DeltavConstants.PN_CHECKED_IN).getValue().toString();
                String checkedInUri = ((Element)new XMLValue(checkedInHref).iterator().next()).getText();
                UriHandler uriHandler = UriHandler.getUriHandler(checkedInUri);
                
                element.setText(WebdavUtils.getAbsolutePath (
                        uriHandler.getAssociatedHistoryUri(), context));
                
                xmlValue.add(element);
            }
            else if (resourceKind instanceof CheckedOutVersionControlled) {
                Element element = new Element(DeltavConstants.E_HREF, DNSP);
                String checkedOutHref = revisionDescriptor.getProperty(
                        DeltavConstants.PN_CHECKED_OUT).getValue().toString();
                String checkedOutUri = ((Element)new XMLValue(checkedOutHref).iterator().next()).getText();
                UriHandler uriHandler = UriHandler.getUriHandler(checkedOutUri);
                
                element.setText(WebdavUtils.getAbsolutePath (
                        uriHandler.getAssociatedHistoryUri(), context));
                
                xmlValue.add(element);
            }
        } catch (JDOMException e) {
            throw new PropertyParseException("Can't parse: " + 
                    DeltavConstants.PN_CHECKED_IN + "/" + 
                    DeltavConstants.PN_CHECKED_OUT);
        }
        
        return xmlValue;
    }

}
