/*
 * $Header: /home/cvspublic/jakarta-slide/src/webdav/server/org/apache/slide/webdav/util/properties/exchange/Constants.java,v 1.2 2005/03/02 11:41:14 luetzkendorf Exp $
 * $Revision: 1.2 $
 * $Date: 2005/03/02 11:41:14 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.webdav.util.properties.exchange;

import org.apache.slide.common.PropertyName;

/**
 * Constants used in this package.
 */
public class Constants {

    private Constants() { }
    
    static final Object TRUE_VALUE = "true";
    static final Object FALSE_VALUE = "false";

    public static final PropertyName PN_IS_COLLECTION = 
        PropertyName.getPropertyName("iscollection"); 
    public static final PropertyName PN_IS_ROOT = 
        PropertyName.getPropertyName("isroot");
    public static final PropertyName PN_HAS_CHILDREN = 
        PropertyName.getPropertyName("haschildren");
    public static final PropertyName PN_CHILDCOUNT = 
        PropertyName.getPropertyName("childcount");
    public static final PropertyName PN_HASSUBS = 
        PropertyName.getPropertyName("hassubs");
    public static final PropertyName PN_LASTACCESSED = 
        PropertyName.getPropertyName("lastaccessed");

}
