package org.apache.slide.webdav.util.properties.exchange;

import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyName;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.webdav.util.WebdavContext;
import org.apache.slide.webdav.util.WebdavUtils;
import org.apache.slide.webdav.util.properties.AbstractComputedProperty;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;

/**
 *  MS Exchange extension property <code>DAV:href</code>.
 * 
 *  <p>The absolute URL of an item.
 */
public class HrefProperty extends AbstractComputedProperty {

    /* (non-Javadoc)
     * @see org.apache.slide.webdav.util.properties.PropertyComputer#getPropertyName()
     */
    public PropertyName getPropertyName() {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see org.apache.slide.webdav.util.properties.PropertyComputer#computeValue(org.apache.slide.common.NamespaceAccessToken, org.apache.slide.content.NodeRevisionDescriptors, org.apache.slide.content.NodeRevisionDescriptor, org.apache.slide.webdav.util.resourcekind.ResourceKind, org.apache.slide.webdav.util.WebdavContext)
     */
    public Object computeValue(NamespaceAccessToken nsaToken,
            NodeRevisionDescriptors revisionDescriptors,
            NodeRevisionDescriptor revisionDescriptor,
            ResourceKind resourceKind, WebdavContext context)
            throws SlideException {
        
        // TODO we need to get more context infos
        return WebdavUtils.getAbsolutePath(revisionDescriptors.getUri(), context);
    }

}
