/*
 * $Header: /home/cvspublic/jakarta-slide/src/webdav/server/org/apache/slide/webdav/util/properties/exchange/IsRootProperty.java,v 1.2 2005/03/02 11:41:14 luetzkendorf Exp $
 * $Revision: 1.2 $
 * $Date: 2005/03/02 11:41:14 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.webdav.util.properties.exchange;

import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyName;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.webdav.util.WebdavContext;
import org.apache.slide.webdav.util.properties.AbstractComputedProperty;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;

/**
 * MS Exchange extension property <code>DAV:isroot</code>.
 * 
 * <p>"The isroot field specifies whether an item is a root folder."
 */
public class IsRootProperty extends AbstractComputedProperty {

    /* (non-Javadoc)
     * @see org.apache.slide.webdav.util.properties.PropertyComputer#getPropertyName()
     */
    public PropertyName getPropertyName() {
        return Constants.PN_IS_ROOT;
    }

    /* (non-Javadoc)
     * @see org.apache.slide.webdav.util.properties.PropertyComputer#computeValue(org.apache.slide.common.NamespaceAccessToken, org.apache.slide.content.NodeRevisionDescriptors, org.apache.slide.content.NodeRevisionDescriptor, org.apache.slide.webdav.util.resourcekind.ResourceKind, org.apache.slide.webdav.util.WebdavContext)
     */
    public Object computeValue(NamespaceAccessToken nsaToken,
            NodeRevisionDescriptors revisionDescriptors,
            NodeRevisionDescriptor revisionDescriptor,
            ResourceKind resourceKind, WebdavContext context)
            throws SlideException {
        return revisionDescriptors.getUri().equals("/") ? 
                Constants.TRUE_VALUE : Constants.FALSE_VALUE;
    }

}
