/*
 * $Header: /home/cvspublic/jakarta-slide/src/webdav/server/org/apache/slide/webdav/util/properties/exchange/LastAccessedMaintainer.java,v 1.2 2005/03/02 12:36:11 luetzkendorf Exp $
 * $Revision: 1.2 $
 * $Date: 2005/03/02 12:36:11 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.webdav.util.properties.exchange;

import java.util.Date;

import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyName;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.SlideTokenWrapper;
import org.apache.slide.content.Content;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.event.VetoException;
import org.apache.slide.webdav.event.WebdavAdapter;
import org.apache.slide.webdav.event.WebdavEvent;
import org.apache.slide.webdav.method.AbstractWebdavMethod;


/**
 * Content event listener that updated the property <code>lastaccessed</code>
 * if the content is retrieved, i.e. <em>the resource is read</em>.
 */
public class LastAccessedMaintainer extends WebdavAdapter
{
    static final PropertyName PN_LAST_ACCESSED = 
        PropertyName.getPropertyName("lastaccessed", NodeProperty.SLIDE_NAMESPACE);
    
    
    private void setLastAccessed(WebdavEvent event) {
        AbstractWebdavMethod method = (AbstractWebdavMethod)event.getSource();
        
        
        NamespaceAccessToken nsaToken = method.getNamespaceAccessToken();
        Content content = nsaToken.getContentHelper();
        
        try {
            NodeRevisionDescriptors nrds = content.retrieve(
                    method.getSlideToken(), method.getRequestUri());
            NodeRevisionDescriptor nrd = content.retrieve(
                    method.getSlideToken(), nrds);
            
            nrd.setProperty(PN_LAST_ACCESSED, Long.toString((new Date()).getTime()));
            
            SlideToken systemToken = new SlideTokenWrapper(method.getSlideToken());
            systemToken.setForceSecurity(false);
            systemToken.setForceLock(false);
            
            content.store(systemToken, method.getRequestUri(), nrd, null);
        } catch (Exception e) {
            // ignore, may be the resource does not exists, ... 
        }
    }

    
    public void get(WebdavEvent event) throws VetoException
    {
        setLastAccessed(event);
    }
    public void propFind(WebdavEvent event) throws VetoException
    {
        setLastAccessed(event);
    }
}