/*
 * $Header: /home/cvspublic/jakarta-slide/src/webdav/server/org/apache/slide/webdav/util/properties/exchange/LastAccessedProperty.java,v 1.2 2005/03/02 12:36:11 luetzkendorf Exp $
 * $Revision: 1.2 $
 * $Date: 2005/03/02 12:36:11 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.webdav.util.properties.exchange;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyName;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.webdav.util.WebdavContext;
import org.apache.slide.webdav.util.properties.AbstractComputedProperty;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;


/**
 * @author Stefan Ltzkendorf
 */
public class LastAccessedProperty extends AbstractComputedProperty
{

    protected static final SimpleDateFormat DATE_FORMAT =
        //new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        //new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'"); // same as createdate
        new SimpleDateFormat("dd/MM/yyyy HH:mm:ss a"); // 3/29/1999 1:30:00 PM, see MSDN library TODO time zone?
    
    /* 
     * @see org.apache.slide.webdav.util.properties.PropertyComputer#getPropertyName()
     */
    public PropertyName getPropertyName()
    {
        return Constants.PN_LASTACCESSED;
    }

    /* 
     * @see org.apache.slide.webdav.util.properties.PropertyComputer#computeValue(org.apache.slide.common.NamespaceAccessToken, org.apache.slide.content.NodeRevisionDescriptors, org.apache.slide.content.NodeRevisionDescriptor, org.apache.slide.webdav.util.resourcekind.ResourceKind, org.apache.slide.webdav.util.WebdavContext)
     */
    public Object computeValue(NamespaceAccessToken nsaToken,
            NodeRevisionDescriptors revisionDescriptors,
            NodeRevisionDescriptor revisionDescriptor,
            ResourceKind resourceKind, WebdavContext context)
            throws SlideException
    {
        Date lastAccessed = null;
        NodeProperty nodeProperty = revisionDescriptor.getProperty(
                LastAccessedMaintainer.PN_LAST_ACCESSED);
        if (nodeProperty != null) {
            lastAccessed = new Date(Long.parseLong(nodeProperty.getValue().toString()));
            Date lastModified = revisionDescriptor.getLastModifiedAsDate();
            if (lastAccessed.after(lastModified)) {
                return DATE_FORMAT.format(lastAccessed);
            } else {
                return DATE_FORMAT.format(lastModified);
            }
        } else {
            return DATE_FORMAT.format(revisionDescriptor.getLastModifiedAsDate());
        }
    }
}
