/*
 * $Header: /home/cvspublic/jakarta-slide/src/webdav/server/org/apache/slide/webdav/util/resourcekind/ResourceKindConfigurator.java,v 1.4 2005/03/29 08:06:06 luetzkendorf Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/29 08:06:06 $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.slide.webdav.util.resourcekind;

import java.util.Enumeration;

import org.apache.slide.event.DomainAdapter;
import org.apache.slide.event.DomainEvent;
import org.apache.slide.util.conf.Configurable;
import org.apache.slide.util.conf.Configuration;
import org.apache.slide.util.conf.ConfigurationException;


/**
 * Eventlistener that allows configuration of resource kind capabilities
 * inside <code>Domain.xml</code>.
 * 
 * <p>Sample:
 * <pre>
 * &lt;event classname="org.apache.slide.event.DomainEvent" enable="true"/> 
 * &lt;listener classname="org.apache.slide.webdav.util.resourcekind.ResourceKindConfigurator">
 *   &lt;configuration>
 *     &lt;resource-kind name="DeltavCompliant">
 *       &lt;live-properties>
 *         &lt;live-property name="myProperty" namespace="http://my.company.com/slide"
 *           computer="org.apache.slide.webdav.util.properties.InheritedProperty">
 *           &lt;computer-configuration>
 *             &lt;default-value>a Value to use if no value could be inherited&lt;/default-value>
 *           &lt;/computer-configuration>
 *         &lt;/live-property>
 *       &lt;/live-properties>
 *     &lt;/resource-kind>
  *    &lt;resource-kind name="DeltavCompliantCollection">
 *       &lt;live-properties>
 *         &lt;live-property name="myCollectionProperty" namespace="http://my.company.com/slide"
 *           computer="org.apache.slide.webdav.util.properties.InheritedProperty">
 *         &lt;/live-property>
 *       &lt;/live-properties>
 *     &lt;/resource-kind>
 *   &lt;/configuration>
 * &lt;/listener>
 * </pre>
 */
public class ResourceKindConfigurator extends DomainAdapter implements Configurable
{
    private Configuration config = null;
    
    public void configure(Configuration configuration)
            throws ConfigurationException
    {
        this.config = configuration;
    }

    public void initialized(DomainEvent event)
    {
        if (config != null) {
            for(Enumeration e = config.getConfigurations("definition");e.hasMoreElements();) {
                Configuration c = (Configuration)e.nextElement();
                
                String resource = c.getAttribute("resource", null);
                ResourceKindManager.initFromResource(resource);
            }
            
            for (Enumeration e = config.getConfigurations("resource-kind"); e.hasMoreElements();) {
                ResourceKindManager.initResourceKind(
                        (Configuration)e.nextElement());
            }
        }
    }
}
