@echo off
setlocal

rem Set defaults
rem NOTE: (1) TP_HOME=.. works if tprocessor.cmd is started from the bin directory.
rem           Otherwise, set TP_HOME to point to the TProcessor installation directory, or use 
rem           the -home argument
rem       (2) DAV_HOST, DAV_PORT and DAV_NAME identify the WebDAV Server to test, i.e. the server
rem           URL is http://%DAV_HOST%:%DAV_PORT%/%DAV_NAME%
rem       (3) TP_STORE identifies the Slide store for the TProcessor to operate on.
rem       (4) TP_USERS is the number of concurrent users for the multiuser testcases.
rem       (5) TP_ITERATIONS is the number of iterations each concurrent user performs an action.
rem       (6) DAV_AUTH specifies the authentication type which is enabled on the server. 
rem           Default os=operating system. 
rem       (4) DAV_GROUP is used for versions supporting groups and users.
rem       (4) DAV_DOMAIN is used for the domain specification of groups and users.
rem       (6) DAV_USER and DAV_PASSWORD are used for authentication against the server.
rem       (7) TP_WORKDB internal DB name for the store configuration required for the webdav and I18N testcases ... :-(
rem       (8) TP_WORKHOST internal host name the internal DB for the store configuration required for the webdav and I18N testcases ... :-(

set TP_WORKDB=xdavtest
set TP_WORKHOST=localhost
set DAV_HOST=localhost
set DAV_AUTH=default
set DAV_GROUP=group
set DAV_DOMAIN=localhost
set DAV_USER=john
set DAV_PASSWORD=john
set DAV_PORT=8080
set DAV_NAME=/slide
set TP_STORE=files
set TP_USERS=1
set TP_ITERATIONS=1
set TESTCASE_PATH=
set TESTCASE_PATTERN=
set XML_REFERENCE=
set PAR=
set TP_DEBUG=false
set TP_VERBOSE=false
set OPTS=

if "%TP_HOME%" == "" set TP_HOME=..

rem Process parms
:LOOP
if "%1" == "" goto INVOKE_TP
if "%1" == "-?" goto HELP
if "%1" == "-h" goto HELP
if "%1" == "-help" goto HELP
if "%1" == "-home" goto SET_HOME
if "%1" == "-davhost" goto SET_HOST
if "%1" == "-davauth" goto SET_AUTH
if "%1" == "-davgroup" goto SET_GROUP
if "%1" == "-davuser" goto SET_USER
if "%1" == "-davdomain" goto SET_DOMAIN
if "%1" == "-davpassword" goto SET_PASSWORD
if "%1" == "-davport" goto SET_PORT
if "%1" == "-davname" goto SET_NAME
if "%1" == "-store" goto SET_STORE
if "%1" == "-users" goto SET_USERS
if "%1" == "-iterations" goto SET_ITERATIONS
if "%1" == "-workdb" goto SET_WORKDB
if "%1" == "-workhost" goto SET_WORKHOST
if "%1" == "-testcase" goto SET_TESTCASE
if "%1" == "-pattern" goto SET_PATTERN
if "%1" == "-exclude" goto SET_EXCLUDE
if "%1" == "-debug" goto SET_DEBUG
if "%1" == "-verbose" goto SET_VERBOSE
if "%1" == "-options" goto SET_OPTIONS
goto SET_PAR

:SET_PAR
set PAR=%PAR% %1
shift 
goto LOOP

:SET_HOME
shift
set TP_HOME=%1
shift
goto LOOP

:SET_HOST
shift
set DAV_HOST=%1
shift
goto LOOP

:SET_AUTH
shift
set DAV_AUTH=%1
shift
goto LOOP

:SET_GROUP
shift
set DAV_GROUP=%1
shift
goto LOOP

:SET_USER
shift
set DAV_USER=%1
shift
goto LOOP

:SET_DOMAIN
shift
set DAV_DOMAIN=%1
shift
goto LOOP

:SET_PASSWORD
shift
set DAV_PASSWORD=%1
shift
goto LOOP

:SET_PORT
shift
set DAV_PORT=%1
shift
goto LOOP

:SET_NAME
shift
set DAV_NAME=%1
shift
goto LOOP

:SET_STORE
shift
set TP_STORE=%1
shift
goto LOOP

:SET_USERS
shift
set TP_USERS=%1
shift
goto LOOP

:SET_ITERATIONS
shift
set TP_ITERATIONS=%1
shift
goto LOOP

:SET_WORKDB
shift
set TP_WORKDB=%1
shift
goto LOOP

:SET_WORKHOST
shift
set TP_WORKHOST=%1
shift
goto LOOP

:SET_TESTCASE
shift
set TESTCASE_PATH=%1
shift
goto LOOP

:SET_PATTERN
shift
set TESTCASE_PATTERN=%TESTCASE_PATTERN% %1
shift
goto LOOP

:SET_EXCLUDE
shift
set TESTCASE_EXCLUDE= %TESTCASE_EXCLUDE% -exclude %1
shift
goto LOOP

:SET_DEBUG
shift
set TP_DEBUG=true
shift
goto LOOP

:SET_VERBOSE
shift
set TP_VERBOSE=true
shift
goto LOOP

:SET_OPTIONS
shift
set OPTS=%1
shift
goto LOOP

:INVOKE_TP
set /A TP_ITER_SMALL=%TP_ITERATIONS%/2


if "%DAV_AUTH%" == "none" set ROOT_USER_PATH=/%DAV_NAME%/users
if "%DAV_AUTH%" == "none" set DAV_USER=unauthenticated
if "%DAV_AUTH%" == "none" set USER_PATH=%ROOT_USER_PATH%/%DAV_USER%
if "%DAV_AUTH%" == "none" set TESTCASE_EXCLUDE=%TESTCASE_EXCLUDE% -exclude "*groupFunctional*" -exclude "*ACL*"

if "%DAV_AUTH%" == "default" set ROOT_USER_PATH=/%DAV_NAME%/users
if "%DAV_AUTH%" == "default" set USER_PATH=%ROOT_USER_PATH%/%DAV_USER%
if "%DAV_AUTH%" == "default" set TESTCASE_EXCLUDE=%TESTCASE_EXCLUDE% -exclude "*groupFunctional*"
if "%DAV_AUTH%" == "default" set ACTION_PATH=/%DAV_NAME%/actions

rem >>> START *** TEMPORARY *** for Tamino only
if "%DAV_AUTH%" == "urmnone" set ROOT_USER_PATH=/%DAV_NAME%/administration/security/userdb
if "%DAV_AUTH%" == "urmnone" set DAV_USER=unauthenticated
if "%DAV_AUTH%" == "urmnone" set USER_PATH=%ROOT_USER_PATH%/users/%DAV_USER%
if "%DAV_AUTH%" == "urmnone" set TESTCASE_EXCLUDE=%TESTCASE_EXCLUDE% -exclude "*groupFunctional*" -exclude "*ACL*"
if "%DAV_AUTH%" == "urmnone" set XML_REFERENCE=taminoReference/

if "%DAV_AUTH%" == "urm" set ROOT_USER_PATH=/%DAV_NAME%/administration/security/userdb
if "%DAV_AUTH%" == "urm" set USER_PATH=%ROOT_USER_PATH%/users/%DAV_USER%
if "%DAV_AUTH%" == "urm" set ACTION_PATH=/%DAV_NAME%/administration/security/actions
if "%DAV_AUTH%" == "urm" set XML_REFERENCE=taminoReference/
rem <<< END *** TEMPORARY *** for Tamino only


set OPTS=%OPTS% -Dxdav.home="%TP_HOME%"
set OPTS=%OPTS% -Dxdav.host=%DAV_HOST%
set OPTS=%OPTS% -Dxdav.port=%DAV_PORT%
set OPTS=%OPTS% -Dxdav.user=%DAV_USER%
set OPTS=%OPTS% -Dxdav.password=%DAV_PASSWORD%

set OPTS=%OPTS% -Dxdav.globalVariableDomainName=%DAV_DOMAIN%
set OPTS=%OPTS% -Dxdav.globalVariableGroup=%DAV_GROUP%
set OPTS=%OPTS% -Dxdav.globalVariableGroupsColl=groups
set OPTS=%OPTS% -Dxdav.globalVariableUsersColl=users
set OPTS=%OPTS% -Dxdav.globalVariableRolesColl=roles

set OPTS=%OPTS% -Dxdav.globalVariableRootUserPath=%ROOT_USER_PATH%
set OPTS=%OPTS% -Dxdav.globalVariableUserPath=%USER_PATH%
set OPTS=%OPTS% -Dxdav.globalVariableServerName=%DAV_NAME%
set OPTS=%OPTS% -Dxdav.globalVariableCollection=%TP_STORE%
set OPTS=%OPTS% -Dxdav.globalVariableUsers=%TP_USERS%
set OPTS=%OPTS% -Dxdav.globalVariableIterationCount=%TP_ITERATIONS%
set OPTS=%OPTS% -Dxdav.globalVariableIterationCountSmall=%TP_ITER_SMALL%
set OPTS=%OPTS% -Dxdav.globalVariablePerformanceIterations=%TP_ITER_SMALL%
set OPTS=%OPTS% -Dxdav.urlencoding=UTF-8
set OPTS=%OPTS% -Dxdav.workdb=%TP_WORKDB%
set OPTS=%OPTS% -Dxdav.workhost=%TP_WORKHOST%
set OPTS=%OPTS% -Dhttpclient.authentication.preemptive=true
set OPTS=%OPTS% -Dxdav.globalVariableXMLReference=%XML_REFERENCE%

if "%TP_VERBOSE%" == "true" set OPTS=%OPTS% -Dxdav.tracingRequest=var

if "%TP_DEBUG%" == "true" set OPTS=%OPTS% -Xdebug
if "%TP_DEBUG%" == "true" set OPTS=%OPTS% -Xnoagent
if "%TP_DEBUG%" == "true" set OPTS=%OPTS% -Djava.compiler=NONE
if "%TP_DEBUG%" == "true" set OPTS=%OPTS% -Xrunjdwp:transport=dt_socket,address=20500,server=y,suspend=y

set CLASSPATH=
call cpbuild %TP_HOME%\lib

if not "%TESTCASE_PATH%" == "" goto SET_SINGLE
if not "%TESTCASE_PATTERN%" == "" goto SET_PATTERN
goto SET_ALL

:SET_SINGLE
set CLS=org.apache.slide.testsuite.testtools.tprocessor.TProcessors -name %TP_HOME%\%TESTCASE_PATH%
goto EXEC

:SET_PATTERN
set CLS=org.apache.slide.testsuite.testtools.walker.MultiTProcessorExecuter
set PAR=%TESTCASE_PATTERN%
if not "%TESTCASE_EXCLUDE%" == "" set Par=%PAR%  %TESTCASE_EXCLUDE%
goto EXEC

:SET_ALL
set CLS=junit.textui.TestRunner
set PAR=org.apache.slide.testsuite.testtools.walker.TProcessorTestExecuter
goto EXEC

:EXEC
@echo on
set JAXP=-Djavax.xml.parsers.SAXParserFactory=org.apache.xerces.jaxp.SAXParserFactoryImpl -Djavax.xml.parsers.DocumentBuilderFactory=org.apache.xerces.jaxp.DocumentBuilderFactoryImpl 
rem set JAXP=-Djavax.xml.parsers.SAXParserFactory=org.apache.crimson.jaxp.SAXParserFactoryImpl -Djavax.xml.parsers.DocumentBuilderFactory=org.apache.crimson.jaxp.DocumentBuilderFactoryImpl
echo %CLASSPATH%
"%JAVA_HOME%\bin\java" %JAXP% %OPTS% %CLS% %PAR%
@echo off
goto END

:HELP
echo.
echo Usage: tprocessor [options] 
echo.
echo Options:
echo   -davauth ^<user db type^>                (default: none)
echo   -davuser ^<webdavserver_user^>           (default: root)
echo   -davdomain ^<security domain^>           (default: localhost)
echo   -davpassword ^<webdavserver_password^>   (default: root)
echo   -davhost ^<webdavserver_host^>           (default: localhost)
echo   -davport ^<webdavserver_port^>           (default: 8080)
echo   -davname ^<webdavserver_name^>           (default: slide)
echo   -store ^<store_to_operate_on^>           (default: files)
echo   -users ^<number_of_users^>               (default: 1)
echo   -iterations ^<number_of_iterations^>     (default: 1)
echo   -testcase ^<xmltestcase_path^>           (relative to the home directory)
echo   -pattern ^<xmltestcase_pattern^>         (wildard is *, file separator is \\)
echo   -exclude ^<xmltestcase_pattern^>         (wildard is *, file separator is \\)
echo.
echo The -davauth option specifies whether authentication is enabled at server side.
echo If both, -testcase and -pattern are omitted, all testcases are executed.
echo.
echo Examples:
echo   (1) Execute all testcases
echo   tprocessor
echo.
echo   (2) Execute one specific testcase
echo   tprocessor -testcase \testsuite\junit\xmltestcases\copy\code\copy201.xml 
echo.
echo   (3) Execute all XML testcases which start with 'copy'
echo   tprocessor -pattern *\\copy*.xml
echo.
echo   (4) Execute all XML testcases which are bellow \testsuite\junit\xmltestcases\copy
echo   tprocessor -pattern *\\copy\\*.xml
echo.
goto END

:END
endlocal

