# NOTE: (1) TP_HOME=.. works if tprocessor.cmd is started from the bin directory.
#           Otherwise, set TP_HOME to point to the TProcessor installation directory, or use 
#           the -home argument
#       (2) DAV_HOST, DAV_PORT and DAV_NAME identify the WebDAV Server to test, i.e. the server
#           URL is http://$DAV_HOST:$DAV_PORT/$DAV_NAME
#       (3) TP_STORE identifies the Slide store for the TProcessor to operate on.
#       (4) TP_USERS is the number of concurrent users for the multiuser testcases.
#       (5) TP_ITERATIONS is the number of iterations each concurrent user performs an action.
#       (6) DAV_AUTH specifies the authentication type which is enabled on the server. 
#           Default os=operating system. 
#       (4) DAV_GROUP is used for versions supporting groups and users.
#	(4) DAV_DOMAIN is used for the domain specification of groups and users.
#       (6) DAV_USER and DAV_PASSWORD are used for authentication against the server.
#       (7) TP_WORKDB internal DB name for the store configuration required for the webdav and I18N testcases ... :-(
#       (8) TP_WORKHOST internal host name the internal DB for the store configuration required for the webdav and I18N testcases ... :-(

use strict;

my $TP_WORKDB="xdavtest";
my $TP_WORKHOST="localhost";
my $DAV_HOST="localhost";
my $DAV_AUTH="none";
my $DAV_GROUP="group";
my $DAV_DOMAIN="localhost";
my $DAV_USER="root";
my $DAV_PASSWORD="root";
my $DAV_PORT="8080";
my $DAV_NAME="slide";
my $TP_STORE="files";
my $TP_USERS="1";
my $TP_ITERATIONS="1";
my $TESTCASE_PATH="";
my $TESTCASE_PATTERN="";
my $PAR="";
my $TP_DEBUG="false";
my $TP_VERBOSE="false";

my $PD="/";
if ($^O eq "MSWin32") {
  $PD="\\";
}

my $TP_HOME;
if ($TP_HOME eq "") { 
  $TP_HOME="..";
}

my $TESTCASE_EXCLUDE;
# Process parms
while (@ARGV && ($_ = $ARGV[0])){
  $_ =~ tr/\//-/;	# allow slash as option identifier
  if ($_ eq "-?" || $_ eq "-h" || $_ eq "-help") {usage(); exit();} 
  elsif ($_ eq "-home")    {shift; $TP_HOME=$ARGV[0];} 
  elsif ($_ eq "-davhost") {shift; $DAV_HOST=$ARGV[0];}
  elsif ($_ eq "-davauth") {shift; $DAV_AUTH=$ARGV[0];}
  elsif ($_ eq "-davgroup"){shift; $DAV_GROUP=$ARGV[0];}
  elsif ($_ eq "-davdomain"){shift; $DAV_DOMAIN=$ARGV[0];}
  elsif ($_ eq "-davuser") {shift; $DAV_USER=$ARGV[0];}
  elsif ($_ eq "-davpassword") {shift; $DAV_PASSWORD=$ARGV[0];}
  elsif ($_ eq "-davport") {shift; $DAV_PORT=$ARGV[0];}
  elsif ($_ eq "-davname") {shift; $DAV_NAME=$ARGV[0];}
  elsif ($_ eq "-store")   {shift; $TP_STORE=$ARGV[0];}
  elsif ($_ eq "-users")   {shift; $TP_USERS=$ARGV[0];}
  elsif ($_ eq "-iterations") {shift; $TP_ITERATIONS=$ARGV[0];}
  elsif ($_ eq "-workdb")  {shift; $TP_WORKDB=$ARGV[0];}
  elsif ($_ eq "-workhost"){shift; $TP_WORKHOST=$ARGV[0];}
  elsif ($_ eq "-testcase"){shift; $TESTCASE_PATH=$ARGV[0];}
  elsif ($_ eq "-pattern") {shift; $TESTCASE_PATTERN=$ARGV[0];}
  elsif ($_ eq "-exclude") {shift; $TESTCASE_EXCLUDE= $ARGV[0];}
  elsif ($_ eq "-debug"){shift; $TP_DEBUG=$ARGV[0];}
  elsif ($_ eq "-verbose") {shift; $TP_VERBOSE=$ARGV[0];}
  else {$PAR="$PAR $_";}
  shift;
}

my $TP_ITER_SMALL=int ($TP_ITERATIONS/2);

my $ROOT_USER_PATH;
my $USER_PATH;
my $ACTION_PATH;

my $PREEMPTIVE_AUTHENTICATION = "true";
if ("$DAV_AUTH" eq "none") {
  $ROOT_USER_PATH="/$DAV_NAME/users";
  $DAV_USER="unauthenticated";
  $USER_PATH="$ROOT_USER_PATH/$DAV_USER";
  $TESTCASE_EXCLUDE="$TESTCASE_EXCLUDE -exclude " . '*groupFunctional* -exclude *ACL*';
  $PREEMPTIVE_AUTHENTICATION = "false";
} elsif ("$DAV_AUTH" eq "default") {
  $ROOT_USER_PATH="/$DAV_NAME/users";
  $USER_PATH="$ROOT_USER_PATH/$DAV_USER";
  $TESTCASE_EXCLUDE="-exclude $TESTCASE_EXCLUDE " . '-exclude *groupFunctional*';
  $ACTION_PATH="$DAV_NAME/actions";
} elsif ("$DAV_AUTH" eq "urmnone") {
  print "Tamino specific test.";
  $ROOT_USER_PATH="/$DAV_NAME/administration/security/userdb";
  $DAV_USER="unauthenticated";
  $USER_PATH="$ROOT_USER_PATH/users/$DAV_USER";
  $ACTION_PATH="/$DAV_NAME/administration/security/actions";
} elsif ("$DAV_AUTH" eq "urm") {
  print "Tamino specific test.";
  $ROOT_USER_PATH="/$DAV_NAME/administration/security/userdb";
  $USER_PATH="$ROOT_USER_PATH/users/$DAV_USER";
  $ACTION_PATH="/$DAV_NAME/administration/security/actions";
}

my $OPTS="-Dxdav.home=\"$TP_HOME\" -Dxdav.host=$DAV_HOST -Dxdav.port=$DAV_PORT -Dxdav.user=$DAV_USER -Dxdav.password=$DAV_PASSWORD -Dxdav.globalVariableDomainName=$DAV_DOMAIN -Dxdav.globalVariableGroupsColl=groups -Dxdav.globalVariableUsersColl=users -Dxdav.globalVariableRolesColl=roles -Dxdav.globalVariableGroup=$DAV_GROUP -Dxdav.globalVariableRootUserPath=$ROOT_USER_PATH -Dxdav.globalVariableUserPath=$USER_PATH -Dxdav.globalVariableServerName=$DAV_NAME -Dxdav.globalVariableCollection=$TP_STORE -Dxdav.globalVariableUsers=$TP_USERS -Dxdav.globalVariableIterationCount=$TP_ITERATIONS -Dxdav.globalVariableIterationCountSmall=$TP_ITER_SMALL -Dxdav.globalVariablePerformanceIterations=$TP_ITER_SMALL -Dxdav.urlencoding=UTF-8 -Dxdav.workdb=$TP_WORKDB -Dxdav.workhost=$TP_WORKHOST -Dhttpclient.authentication.preemptive=$PREEMPTIVE_AUTHENTICATION";

$ENV{"CLASSPATH"}="";
cpbuild("$TP_HOME"."$PD"."lib");

my $CLS;
if ("$TESTCASE_PATH") {
  $CLS="org.apache.slide.testsuite.testtools.tprocessor.TProcessors -name $TP_HOME$PD$TESTCASE_PATH";
}
elsif ("$TESTCASE_PATTERN") {
  $CLS="org.apache.slide.testsuite.testtools.walker.MultiTProcessorExecuter";
  $PAR="$TESTCASE_PATTERN";
  if ("$TESTCASE_EXCLUDE") {
    $PAR="$PAR -exclude $TESTCASE_EXCLUDE";
  }
} else {
  $CLS="junit.textui.TestRunner";
  $PAR="org.apache.slide.testsuite.testtools.walker.TProcessorTestExecuter";
}

my $JH=$ENV{"JAVA_HOME"};
my $CMD="$JH"."$PD"."bin"."$PD"."java";
# print ("\"$CMD\" $OPTS $CLS $PAR\n");
print ("$CMD $OPTS $CLS $PAR\n");
system ("$CMD $OPTS $CLS $PAR");


sub usage {
print <<EOU;

Usage: tprocessor [options] 

Options:
  -davauth <user db type>                (default: none)
  -davuser <webdavserver_user>           (default: root)
  -davdomain <security domain>           (default: localhost)
  -davpassword <webdavserver_password>   (default: root)
  -davhost <webdavserver_host>           (default: localhost)
  -davport <webdavserver_port>           (default: 8080)
  -davname <webdavserver_name>           (default: slide)
  -store <store_to_operate_on>           (default: files)
  -users <number_of_users>               (default: 1)
  -iterations <number_of_iterations>     (default: 1)
  -testcase <xmltestcase_path>           (relative to the home directory)
  -pattern <xmltestcase_pattern>         (wildard is *, file separator is \\)
  -exclude <xmltestcase_pattern>         (wildard is *, file separator is \\)

The -davauth option specifies whether authentication is enabled at server side.
If both, -testcase and -pattern are omitted, all testcases are executed.

Examples:
  (1) Execute all testcases
  tprocessor

  (2) Execute one specific testcase
  tprocessor -testcase \testsuite\junit\xmltestcases\copy\code\copy201.xml 

  (3) Execute all XML testcases which start with 'copy'
  tprocessor -pattern *\\copy*.xml

  (4) Execute all XML testcases which are bellow \testsuite\junit\xmltestcases\copy
  tprocessor -pattern *\\copy\\*.xml
EOU
 ;
}

sub cpbuild {
  my $path=$_[0];
  my $CP="";
  print "Appending $path and all jar files contained in $path to the classpath...\n\n";

  my $SEP=":";
  if ($^O eq "MSWin32") {
     $SEP=";";
  }
  my $wrk=$ENV{"CLASSPATH"};
  $ENV{"CLASSPATH"}=$wrk.$SEP.$path;
  opendir (JD, "$path") || die "Cannot open $path";
  foreach (readdir(JD)) {
    next if (substr($_, length($_) - 4, length($_)) ne ".jar");
    if (!$CP) {$CP=$path.$PD.$_}
    else {$CP=$CP.$SEP.$path.$PD.$_}
  }
  $ENV{"CLASSPATH"}=$ENV{"CLASSPATH"}.$SEP.$CP;
  closedir JD;
}
