/*
 * $Header: /home/cvspublic/jakarta-slide/testsuite/testsuite/junit/src/org/apache/slide/testsuite/testtools/tprocessor/TErrorsReport.java,v 1.8 2005/02/21 17:48:00 luetzkendorf Exp $
 * $Revision: 1.8 $
 * $Date: 2005/02/21 17:48:00 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2002 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.slide.testsuite.testtools.tprocessor;

import java.io.*;
import java.net.*;
import java.util.*;
import java.text.*;
import org.jdom.*;
import org.jdom.input.*;
import org.jdom.output.*;
import org.apache.slide.testsuite.testtools.tutil.*;

/**
 ** Errors report from a TestcasesResults.xml file.
 **
 ** @version   0.1
 **/
public class TErrorsReport {
    /**
     *
     */
    public static void main(String[] args) {
        try {
            TArgs a = new TArgs( args );
            File f = null;
            String inname = null;
            String outname = null;
            PrintStream out = System.out;
            
            if( a.isOptionSet("infile") ) {
                inname = a.get("infile");
                f = new File( inname );
                if( !f.exists() )
                    out.println( "\nFile "+inname+" not found\n" );
            }

            if( a.isOptionSet("outfile") ) {
                outname = a.get("outfile");
                if( "stdout".equalsIgnoreCase(outname) ) {
                    out = System.out;
                    out.println("\n\n");
                }
                else if( "stderr".equalsIgnoreCase(outname) ) {
                    out = System.err;
                    out.println("\n\n");
                }
                else {
                    f = new File( outname );
                    out = new PrintStream( new FileOutputStream(f) );
                }
            }
            else {
                out.println("\n\n");
            }
            
            SAXBuilder sax = new SAXBuilder();
            Document doc = sax.build( inname );
            Element root = doc.getRootElement();
            Iterator tci = root.getChildren("testCase").iterator();
            long errors = 0;
            out.println(
                "********************************************************************************\n"+
                "TESTSUITE ERRORS REPORT\n"+
                "Report created.......: "+DateFormat.getDateTimeInstance(DateFormat.SHORT, DateFormat.SHORT, Locale.GERMANY).format(new Date())+"\n"+
                "Testsuite executed...: "+root.getChild("excecutionDate").getText()+"\n"+
                "Input log............: "+inname+"\n"+
                "********************************************************************************\n");
            boolean error = false;
            while( tci.hasNext() ) {
                String cause = null;
                error = false;
                Element tc = (Element)tci.next();
                Iterator xsi = tc.getChildren("executeStep").iterator();
                cause = "";
                while( xsi.hasNext() ) {
                    Element xs = (Element)xsi.next();
                    Element r = xs.getChild("result");
                    if( "Success".equals(r.getText()) )
                    if( r!=null && r.getText()!=null && "Success".equals(r.getText()) )
                        continue;
                    error = true;
                    errors++;
                    Iterator xsei = xs.getChildren().iterator();
                    while( xsei.hasNext() ) {
                        Element xse = (Element)xsei.next();
                        if( "method".equals(xse.getName()) )
                            continue;
                        if( "url".equals(xse.getName()) )
                            continue;
                        if( "result".equals(xse.getName()) )
                            continue;
                        if( "time".equals(xse.getName()) )
                            continue;
                        cause = cause+"- "+xse.getName()+": ";
                    }
                    // if an exception occured, no method or url may be present
                    if (xs.getChild("method") != null && xs.getChild("url") != null) {
                        cause = cause+xs.getChild("method").getTextTrim()+" "+xs.getChild("url").getTextTrim()+"\n";
                    }
                }
                if( error ) {
                    String l = tc.getChild("fileName").getText();
                    int i = l.indexOf("testsuite"+File.separator+"junit");
                    l = l.substring( i ).trim();
                    out.println("Testcase: "+l);
                    out.println(cause);
                }
            }
            out.println("\nResult: "+errors+" errors\n");
            out.close();
        }
        catch( Exception x ) { x.printStackTrace(); }
    }
}



