/*
 * $Header: /home/cvspublic/jakarta-slide/testsuite/testsuite/junit/src/org/apache/slide/testsuite/testtools/tutil/TArgs.java,v 1.6 2005/01/10 18:26:40 luetzkendorf Exp $
 * $Revision: 1.6 $
 * $Date: 2005/01/10 18:26:40 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2002 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.slide.testsuite.testtools.tutil;

import java.util.*;



/********************************************************************************
*  Args.java
*  <BR><BR><B><U> General description of Args.java </U></B><BR>
*  <UL>
*   provides a simple mechanism for reading command line arguments
*  <p>
*  The command line options are read into a hashmap and can be retrieved.
*  <LI> A command line option having a value must start with '/' or '-' </LI>
*  <LI> The value must be separated from option with one or more blanks (-d directory)</LI>
*  <LI> An option need not to have a value  (-x)</LI>
*  <LI> if an option is expected but does not start with '/' or '-', it is treated as
*       option without a value (nodebug) </LI>
*  <LI> The option is stored without the leading '/' or '-'</LI>
*
*  </UL>
*  <BR><BR><B><U> <font color=red>Planned</font> features </U></B><BR>
*  <UL>
*  <LI>  </LI>
*  </UL>
* <B>History:</B><UL>
* <LI>19981119 wam  Initial version</LI>
* </UL>
 * @version $Revision: 1.6 $
********************************************************************************/



public class TArgs {
  private Map   container = new HashMap();
  private String[] args = null;
  
  
  /**
  * constructor.
  */
  public TArgs (String [] args) {
    String s;
    String key = null;
    String val = null;
    
    this.args = args;
    
    for (int i = 0; i < args.length; i++) {
      s = args[i];
      if (isOption (s)) {
        key = s.substring (1);
        if (i + 1 >= args.length) {
          val = null;
          container.put (key, val);
          // [PZA] does not work with break here !!!
          return;
        }
        
        if (isOption (args[i+1]))
          val = null;
        else
          val = args [++i];
      }
      else {
        key = s;
        val = null;
      }
      container.put (key, val);
    }
  }

  /**
   ** args
   **
   ** @pre
   ** @post
   **
   ** @return  the arguments as String array
   **
   **/
  public String[] args() {
    return args;
  }
  
  /**
  * checks, if the specified option is set
  */
  public boolean isOptionSet (String option) {
    return container.containsKey (option);
  }
  
  /*
  * returns the value of an option or null, if either not set or option has no value
  */
  public String get (String option) {
    return (String) container.get (option);
  }
  
  public static void main (String [] argv) {
    TArgs args = new TArgs (argv);
    
    System.out.println ("-d  is: " + args.get ("d"));
    System.out.println ("-x set? " + args.isOptionSet ("x"));
  }

  private boolean isOption (String s) {
    return s.startsWith ("-");
  }
}
