/*
 * $Header: /home/cvspublic/jakarta-slide/testsuite/testsuite/junit/src/org/apache/slide/testsuite/testtools/walker/MultiTProcessorExecuter.java,v 1.11 2004/07/28 09:31:50 ib Exp $
 * $Revision: 1.11 $
 * $Date: 2004/07/28 09:31:50 $
 *
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2002 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Slide", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.slide.testsuite.testtools.walker;

//TProcessor import
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.slide.testsuite.testtools.tprocessor.TProcessors;


/**
 * Call T_Processor for a set of specified patterns
 *
 * @version $Revision: 1.11 $
 */
public class MultiTProcessorExecuter {

    private String xdavHome = System.getProperty("xdav.home");
    private String xdavInPath = System.getProperty("xdav.inpath");
    private String xdavOutfile = System.getProperty("xdav.outfile");

    private static boolean      result       = true;


    /**
     ** Constructor that creates the GenericBeanContextChildTest with the given name.
     ** Constructor description
     **
     ** @pre        true
     ** @post       true
     **
     ** @param      name the given name
     **
     ** @category   procedure
     **/
    public MultiTProcessorExecuter() {
        if (xdavHome == null) {
            System.out.println("xdav.home is not set!");
            throw new Error("xdav.home is not set!");
        }
        if (xdavInPath != null) {
            xdavHome = xdavInPath;
        } else {
            xdavHome = xdavHome+java.io.File.separatorChar+"testsuite";
            xdavHome = xdavHome+java.io.File.separatorChar+"junit";
            xdavHome = xdavHome+java.io.File.separatorChar+"xmltestcases";
        }
        if (xdavOutfile == null) {
            xdavOutfile = xdavHome+java.io.File.separatorChar+".."+java.io.File.separatorChar+"testCasesResults.xml";
        }
    }



    public void exceuteAllSpecifiedXMLFileByTProcessor(String[] include, String[] exclude) throws Exception {

        exceuteAllSpecifiedXMLFileByTProcessor(
            new java.io.PrintStream(new FileOutputStream(xdavOutfile)),
            include,
            exclude);



    }




    public void exceuteAllSpecifiedXMLFileByTProcessor(final PrintStream resultOutput, String[] include, String[] exclude) throws Exception {

        final int[] testCaseCount = new int[2];

        testCaseCount[0] = 0;
        testCaseCount[1] = 0;

        long time = System.currentTimeMillis();
        java.util.Date startDate = new java.util.Date();

        resultOutput.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
//        resultOutput.println("<!DOCTYPE testSuite SYSTEM \"testCasesResults.dtd\">");
        resultOutput.println("<testSuite>");
        resultOutput.println("   <excecutionDate>" + new java.text.SimpleDateFormat("dd.MM.yy HH:mm").format(startDate) + "</excecutionDate>");
        resultOutput.println("   <resultFileName>" + xdavHome+java.io.File.separatorChar+".."+java.io.File.separatorChar+"testCasesResults.xml" + "</resultFileName>");

        DirectoryWalker walker = new DirectoryWalker(xdavHome, include, exclude, new WalkerJob() {
                    public void job(String jobName) {
                        String[] parameters = new String[2];
                        parameters[0] = "-name";
                        parameters[1] = jobName;
//                      System.out.println(jobName);
                        if (!TProcessors.mainExecuter(parameters, resultOutput, testCaseCount))
                            result = false;
                            //assert("Wrong extension found " + jobName, jobName.endsWith("xml"));
                    }
                }
            );


        resultOutput.println("   <result>" + (!result?"ERROR":"Success") + "</result>");
        resultOutput.println("   <time>" + ((System.currentTimeMillis() - time)) + "</time>");
        resultOutput.println("   <testElementCount>" + testCaseCount[0] + "</testElementCount>");
        resultOutput.println("   <testElementErrors>" + testCaseCount[1] + "</testElementErrors>");
        resultOutput.println("</testSuite>");
        resultOutput.close();



        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        // TODO: system uri
        System.out.println("<!DOCTYPE testSuite SYSTEM \"\\\\bolrep2\\projects\\xdavNC\\TaTooDev\\xdav\\testsuite\\junit\\testCasesResults.dtd\">");
        System.out.println("<testSuite>");
        System.out.println("   <excecutionDate>" + new java.text.SimpleDateFormat("dd.MM.yy HH:mm").format(startDate) + "</excecutionDate>");
        System.out.println("   <resultFileName>" + xdavHome+java.io.File.separatorChar+".."+java.io.File.separatorChar+"testCasesResults.xml" + "</resultFileName>");
        System.out.println("   <result>" + (!result?"ERROR":"Success") + "</result>");
        System.out.println("   <time>" + ((System.currentTimeMillis() - time)) + "</time>");
        System.out.println("   <testElementCount>" + testCaseCount[0] + "</testElementCount>");
        System.out.println("   <testElementErrors>" + testCaseCount[1] + "</testElementErrors>");
        System.out.println("</testSuite>");
        System.out.println();
        System.out.println();


    }


    public static void main(String[] args) {
        List include = new ArrayList();
        List exclude = new ArrayList();
        exclude.add("CVS");
        for (int i=0; i < args.length; i++) {
            boolean includeSpecified = true;
            if (args[i].equals("-exclude")) {
                includeSpecified = false;
                i++;
            }
            if (args[i].equals("-include")) {
                includeSpecified = true;
                i++;
            }

            if (!args[i].endsWith(".xml")) args[i] = args[i] + ".xml";
            if (!args[i].startsWith("*"))  args[i] = "*" + args[i];

            if (includeSpecified) include.add(args[i]);
            else                  exclude.add(args[i]);
            System.out.println("Arguments found : " + (includeSpecified?" + ":" - ") + args[i]);
        }

        try {
            String[] incl = new String[include.size()];
            String[] excl = new String[exclude.size()+1];
            for (int i=0; i<include.size(); i++) incl[i] = (String)include.get(i);
            for (int i=0; i<exclude.size(); i++) excl[i] = (String)exclude.get(i);
            excl[exclude.size()] = "*CVS*";
            new MultiTProcessorExecuter().exceuteAllSpecifiedXMLFileByTProcessor(incl, excl); }
        catch (Exception e) { e.printStackTrace(); }
    }


}
