/*
 * $Header: /home/cvspublic/jakarta-slide/wck/src/org/apache/slide/simple/authentication/SessionAuthenticationManager.java,v 1.1 2004/12/09 12:17:09 ozeigermann Exp $
 * $Revision: 1.1 $
 * $Date: 2004/12/09 12:17:09 $
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.simple.authentication;

/**
 * Manager for session handling and authentication of your custom store. Is used
 * by the {@link org.apache.slide.simple.authentication.JAASLoginModule}.
 * 
 * <p>
 * This interface is used to authenticate a user and if this succeeds an object -
 * e.g. a session or a connection - that allows access to your custom store must
 * be returned.
 * </p>
 *  
 */
public interface SessionAuthenticationManager {

    /**
     * Tries to authenticate a user to the custom store and return an object
     * that will allow for access to the custom store. Slide does not care at
     * all what the nature of the object is.
     * 
     * @param user
     *            the name of the user who is requesting an authenticated
     *            session
     * @param password
     *            the password of the user who is requesting an authenticated
     *            session
     * @return an object representing the sesssion or connection or whatever is
     *         necessary for acccess to your custom store
     * @throws Exception
     *             in case authentication to your custom store failed or
     *             anything else went wrong
     */
    Object getAuthenticationSession(String user, String password) throws Exception;

    /**
     * Tries to authenticate a user to the custom store and return an object
     * that will allow for access to the custom store. No password is supplied
     * as this is a trusted user who has proven its identity to JAAS
     * authentication before.
     * 
     * @param user
     *            the name of the user who is requesting an authenticated
     *            session
     * @return an object representing the sesssion or connection or whatever is
     *         necessary for acccess to your custom store
     * @throws Exception
     *             in case authentication to your custom store failed or
     *             anything else went wrong
     */
    Object getAuthenticationSession(String user) throws Exception;

    /**
     * Closes an authentication session that is no longer used by Slide. It is
     * guaranteed that no further requests will be done to this session. The
     * only exception is when the same object is returned again when
     * authenticating.
     * 
     * @param session
     *            the authentication session to be closed
     * @throws Exception
     *             in case anything went wrong
     */
    void closeAuthenticationSession(Object session) throws Exception;

}