/*
 * $Header: /home/cvspublic/jakarta-slide/wck/src/org/apache/slide/simple/reference/FakePoolingConnectionManager.java,v 1.1 2004/12/09 12:17:09 ozeigermann Exp $
 * $Revision: 1.1 $
 * $Date: 2004/12/09 12:17:09 $
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.simple.reference;

import org.apache.slide.simple.authentication.AbstractPoolingConnectionManager;

/**
 * Sample implementation for the
 * {@link org.apache.slide.simple.authentication.AbstractPoolingConnectionManager}.
 * It simply grants access to any user remembering the password for later access
 * without it. User "root" is an exception with no access to show what happens when
 * access is denied. Addtionally, every connection with a counter ending in "1" will be
 * invalid to show what happens when a connection times out or looses validity for any 
 * other reason.
 * <br><br>
 * A triple of the username and the password and a counter separated by colons is 
 * returned as the connection.
 */
public class FakePoolingConnectionManager extends AbstractPoolingConnectionManager {

    public static int connectionCnt = 0;

    public static String DENY_USER = "root";

    protected synchronized Object createPhysicalConnection(String user, String password) throws Exception {
        // just to show what happens when a user is not authorized
        if (!DENY_USER.equals(user)) {
            String connection = user + ":" + password + ":" + connectionCnt++;
            System.out.println("Creating connection: " + connection);
            return connection;
        } else {
            System.out.println("Denying access for: " + user);
            throw new Exception("User " + user + " has no access!");
        }
    }

    protected synchronized void closePhysicalConnection(Object session) throws Exception {
        System.out.println("Closing connection: " + session);
    }

    protected void invalidatePhysicalConnection(Object session) throws Exception {
        System.out.println("Invalidating connection: " + session);
    }

    protected void wakeupPhysicalConnection(Object session) throws Exception {
        System.out.println("Wake up connection: " + session);
    }

    protected boolean isPhysicalConnectionValid(Object session) {
        // just to show what happens when a no longer is valid (e.g. because of
        // a timeout or shutdown)
        if (session.toString().endsWith("1")) {
            System.out.println("NOK Checking connection: " + session);
            return false;
        } else {
            System.out.println("OK Checking connection: " + session);
            return true;
        }
    }

}