/*
 * $Header: /home/cvspublic/jakarta-slide/wck/src/org/apache/slide/simple/reference/FakeSessionManager.java,v 1.1 2004/12/09 12:17:09 ozeigermann Exp $
 * $Revision: 1.1 $
 * $Date: 2004/12/09 12:17:09 $
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.simple.reference;

import java.util.HashMap;
import java.util.Map;

import org.apache.slide.simple.authentication.SessionAuthenticationManager;

/**
 * Reference implementation for the
 * {@link org.apache.slide.simple.authentication.SessionAuthenticationManager}.
 * It simply grants access to any user remembering the password for later access
 * without it. A pair of the username and the password separated by a colon is 
 * returned as the session.
 */
public class FakeSessionManager implements SessionAuthenticationManager {

    private Map fakeMap = new HashMap();
    
    public Object getAuthenticationSession(String user) {
        String fakeSession = (String) fakeMap.get(user);
        return fakeSession;
    }

    public Object getAuthenticationSession(String user, String password) {
        String fakeSession = user+":"+password;
        fakeMap.put(user, fakeSession);
        return fakeSession;
    }

    public void closeAuthenticationSession(Object session) {
    }

}
