/*
 * $Header: /home/cvspublic/jakarta-slide/wck/src/org/apache/slide/simple/store/BasicWebdavStoreFactory.java,v 1.1 2005/02/09 19:16:28 ozeigermann Exp $
 * $Revision: 1.1 $
 * $Date: 2005/02/09 19:16:28 $
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.simple.store;


/**
 * Factory for instances of {@link org.apache.slide.simple.store.BasicWebdavStore}. Is used
 * by {@link org.apache.slide.simple.store.WebdavStoreAdapter} to create a store instance per
 * request.
 * 
 * @see org.apache.slide.simple.store.BasicWebdavStore
 * @see org.apache.slide.simple.store.WebdavStoreAdapter
 * 
 */
public interface BasicWebdavStoreFactory
{
    /**
     * Creates a new instance of {@link org.apache.slide.simple.store.BasicWebdavStore}. Will
     * be called upon each reques from the WebDAV layer.
     * 
     * @return a new instance of {@link org.apache.slide.simple.store.BasicWebdavStore}
     * @throws Exception in case anything went wrong
     */
    BasicWebdavStore newInstance() throws Exception;
}
