/*
 * $Header: /home/cvspublic/jakarta-slide/wck/src/org/apache/slide/simple/store/WebdavStoreMacroCopyExtension.java,v 1.1 2004/12/09 12:17:09 ozeigermann Exp $
 * $Revision: 1.1 $
 * $Date: 2004/12/09 12:17:09 $
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.simple.store;

import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.lock.ObjectLockedException;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.simple.reference.WebdavFileStore;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNotFoundException;

/**
 * Optional extension to the
 * {@link org.apache.slide.simple.store.BasicWebdavStore basic store} with macro
 * call backs.
 * 
 * <p>
 * Be sure to read the Javadocs of the
 * {@link org.apache.slide.simple.store.BasicWebdavStore basic one} first!
 * </p>
 * 
 * <p>
 * <em>Caution: It is most important to understand that this is no general purpose store. 
 * It has been designed to solely work with access to Slide via WebDAV with general methods.
 * It relies on certain sequences of calls that are done when the Slide core is being accessed through
 * the WebDAV layer. Other sequences are likely to make this store fail.</em>
 * </p>
 * 
 * @see BasicWebdavStore
 * @see WebdavFileStore
 * @see WebdavStoreAdapter
 * @version $Revision: 1.1 $
 */
public interface WebdavStoreMacroCopyExtension {

    /**
     * Recursively copies an object.
     * 
     * @param sourceUri the source URI of the copy
     * @param targetUri the destination URI of the copy
     * @param overwrite <code>true</code> if the target shall be copied to even if it already exsis
     * @param recursive <code>true</code> if all descendants of the source should be copied as well
     * @throws ObjectNotFoundException if the object to copy from was not found
     * @throws ObjectAlreadyExistsException if the object to copy to to was already there
     * @throws ServiceAccessException
     *             if anything else goes wrong while copying the object
     * @throws AccessDeniedException
     *             if the store denies copying this object or any descendants
     * @throws ObjectLockedException if the object has been locked internally
     */
    public void macroCopy(String sourceUri, String targetUri, boolean overwrite, boolean recursive) throws ServiceAccessException, AccessDeniedException, ObjectNotFoundException,
            ObjectAlreadyExistsException, ObjectLockedException;

}