/*
 * $Header: /home/cvspublic/jakarta-slide/wck/src/org/apache/slide/simple/store/WebdavStoreMacroDeleteExtension.java,v 1.1 2004/12/09 12:17:09 ozeigermann Exp $
 * $Revision: 1.1 $
 * $Date: 2004/12/09 12:17:09 $
 *
 * ====================================================================
 *
 * Copyright 2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.slide.simple.store;

import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.lock.ObjectLockedException;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.simple.reference.WebdavFileStore;
import org.apache.slide.structure.ObjectNotFoundException;

/**
 * Optional extension to the
 * {@link org.apache.slide.simple.store.BasicWebdavStore basic store} with macro
 * call backs.
 * 
 * <p>
 * Be sure to read the Javadocs of the
 * {@link org.apache.slide.simple.store.BasicWebdavStore basic one} first!
 * </p>
 * 
 * <p>
 * <em>Caution: It is most important to understand that this is no general purpose store. 
 * It has been designed to solely work with access to Slide via WebDAV with general methods.
 * It relies on certain sequences of calls that are done when the Slide core is being accessed through
 * the WebDAV layer. Other sequences are likely to make this store fail.</em>
 * </p>
 * 
 * @see BasicWebdavStore
 * @see WebdavFileStore
 * @see WebdavStoreAdapter
 * @version $Revision: 1.1 $
 */
public interface WebdavStoreMacroDeleteExtension {

    /**
     * Deletes an object recursively.
     * 
     * @param targetUri
     *            Uri of the object to delete
     * @throws ObjectNotFoundException
     *             if the object to delete was not found
     * @throws ServiceAccessException
     *             if anything else goes wrong while deleting the object
     * @throws AccessDeniedException
     *             if the store denies deleting this object or any descendants
     * @throws ObjectLockedException
     *             if the object has been locked internally
     */
    public void macroDelete(String targetUri) throws ServiceAccessException, AccessDeniedException,
            ObjectNotFoundException, ObjectLockedException;

}