/**
 * @author Thomas Bellembois
 * @version
 * 
 * Creation date : 21 juil. 2005
 * Last modification :
 */
package org.esupportail.injac.webdavServer.esupWDServerManager.userInterface;

import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLPropertiesConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.injac.webdavServer.esupWDServerManager.ICommand;
import org.esupportail.injac.webdavServer.esupWDServerManager.IPACProduct;
//import org.esupportail.injac.webdavServer.esupWDServerManager.controller.CWDServerManager.CreateHomedirAction;
//import org.esupportail.injac.webdavServer.esupWDServerManager.controller.CWDServerManager.CreateInjacSpaceAction;
//import org.esupportail.injac.webdavServer.esupWDServerManager.controller.CWDServerManager.GetNumberLDAPEntriesAction;
import org.esupportail.injac.webdavServer.esupWDServerManager.controller.CWDServerManager.MkdirAction;
import org.esupportail.injac.webdavServer.esupWDServerManager.controller.CWDServerManager.RmAction;


public abstract class PWDServerManager implements IPACProduct {

	protected static Log log;

	protected String webdavServerURL;
	protected String webServiceURL;
	protected String webdavFilesPath;
	protected String webdavRolesPath;
	protected String webdavLocalRolesPath;
	protected String webdavUPortalRolesPath;
	protected String webdavUsersPath;
	protected String connectUserName;
	protected String connectPassword;
	
	protected String ldapURL;
	protected String ldapPort;
	protected String ldapBaseDN;
	protected String ldapScope;
	protected String ldapPrincipal;
	protected String ldapCredential;
	protected String ldapUIDAttribut;
	protected String ldapMaxResult;
	
	protected String homedirLDAPFilter;
	protected String homedirHashType;
	
	protected String propToModify;
	protected String newValue;
	
	protected String currentPath;
	protected String oldPath;
	protected String newPath;
	protected boolean resourceExists;
	
	protected int newQuotaUsebBytes;
	protected int newQuotaAvailableBytes;
	protected int childrenDepth;
	protected boolean newVirtualRoot;
	protected boolean calculateQuotaUsedBytes;
	protected boolean removeQuotaProcessChildren;
	
	protected String injacAdmin;
	protected String injacSpaceName;
	protected String injacChannelAccount;
	
	protected String spaceName;
	protected String spaceLDAPFilter;
	protected String spaceLDAPAttribute;
	protected String spaceRegexp;
	protected String spaceRegexpSeparator;
	protected String spacePatternFilePath;
	
	public ICommand getQuotaAvailableBytesAction;
	public ICommand getQuotaUsedBytesAction;
	public ICommand calculateQuotaUsedBytesAction;
	public ICommand getChildrenAction;
	public ICommand getTreeQuotaInformationAction;
	public ICommand getVirtualRootAction;
	public ICommand patchQuotaAvailableBytesAction;
	public ICommand patchQuotaUsedBytesAction;
	public ICommand setVirtualRootAction;
	public ICommand removeQuotaAction;
	public ICommand setQuotaAction;
	public ICommand connectAction;
	public ICommand createHomedirAction;
	public ICommand getNumberLDAPEntriesAction;
	public ICommand cdAction;
	public ICommand existAction;
	public ICommand mkdirAction;
	public ICommand rmAction;
	public ICommand createInjacSpaceAction;
	public ICommand createSpaceAction;
	
	public abstract void displayQuotaAvailableBytes(int quotaAvailableBytes);
	public abstract void displayQuotaUsedBytes(int quotaUsedBytes);
	public abstract void displayActionResult(String actionResult);
	public abstract void displayChildren(String children);
	public abstract void displayVirtualRoot(boolean virtualRoot);
	public abstract void displayCd(String path);
	public abstract void displayExist(boolean exist);
	public abstract void displayNumberLDAPEntries(int displayNumberLDAPEntries);
	
	public abstract int getChildrenDepth();
	public abstract String getCurrentPath();
	public abstract String getNewPath();
	public abstract boolean getChildrenProcessFiles();
	public abstract boolean getTreeQuotaInformationProcessFiles();
	public abstract int getNewQuotaAvailableBytes();
	public abstract int getNewQuotaUsedBytes();
	public abstract boolean getPatchQuotaUsedBytesOverwrite();
	public abstract boolean getNewVirtualRoot();
	public abstract boolean getRemoveQuotaProcessChildren();
	public abstract boolean getSetQuotaCalculateQuotaUsedBytes(); 
	public abstract String getWebServiceURL();
	public abstract String getConnectPassword();
	public abstract String getConnectUserName();
	public abstract String getWebdavServerURL();
	public abstract String getLdapUrl();
	public abstract String getLdapPort();
	public abstract String getLdapBaseDn();
	public abstract String getLdapPrincipal();
	public abstract String getLdapCredential();
	public abstract String getLdapUserUidAttribut();
	public abstract String getLdapMaxResults();
	public abstract String get_ldapScope();
	public abstract String getDirectoriesStructureHashType();
	public abstract String getHomedirRoot();
	public abstract String getUsersPath();
	public abstract String getRolesPath();
	public abstract String getLocalRolesPath();
	public abstract String getUportalRolesPath();
	public abstract String getHomedirLdapFilter();
	
	public abstract String getInjacAdmin();
	public abstract String getInjacSpaceName();
	public abstract String getInjacChannelAccount();

	public abstract String getSpaceLDAPAttribute();
	public abstract String getSpaceLDAPFilter();
	public abstract String getSpaceName();
	public abstract String getSpacePatternFilePath();
	public abstract String getSpaceRegexp();
	public abstract String getSpaceRegexpSeparator();
	
	public abstract void startInterface();
	
	XMLPropertiesConfiguration xmlPropertiesConfiguration;
	
	public PWDServerManager() throws ConfigurationException {
		log = LogFactory.getLog(getClass().getName());
		xmlPropertiesConfiguration = new XMLPropertiesConfiguration(new File("properties/configuration.xml"));
		loadConfiguration();	
	}// PQuotaManager
	
	public void loadConfiguration() {
		webdavServerURL = getConfigurationProperty("webdavServerURL");
		webServiceURL = getConfigurationProperty("webServiceURL");
		connectUserName = getConfigurationProperty("connectUserName");
		connectPassword = getConfigurationProperty("connectPassword");
		// deprecated parameters, but we keep it in case of...
//		webdavFilesPath = getConfigurationProperty("webdavFilesPath");
//		webdavRolesPath = getConfigurationProperty("webdavRolesPath");
//		webdavLocalRolesPath = getConfigurationProperty("webdavLocalRolesPath");
//		webdavUPortalRolesPath = getConfigurationProperty("webdavUPortalRolesPath");
//		webdavUsersPath = getConfigurationProperty("webdavUsersPath");
//		homedirLDAPFilter = getConfigurationProperty("homedirLDAPFilter");
//		homedirHashType = getConfigurationProperty("homedirHashType");
//		ldapUIDAttribut = getConfigurationProperty("ldapUIDAttribut");
		ldapURL = getConfigurationProperty("ldapURL");
		ldapBaseDN = getConfigurationProperty("ldapBaseDN");
		ldapPort = getConfigurationProperty("ldapPort");
		ldapScope = getConfigurationProperty("ldapScope");
		ldapPrincipal = getConfigurationProperty("ldapPrincipal");
		ldapCredential = getConfigurationProperty("ldapCredential");
		ldapMaxResult = getConfigurationProperty("ldapMaxResult");
		
		log.debug("webdavServerURL="+webdavServerURL+"\n");
		log.debug("webServiceURL="+webServiceURL+"\n");
		log.debug("connectUserName="+connectUserName+"\n");
		log.debug("connectPassword="+connectPassword+"\n");
//		log.debug("webdavFilesPath="+webdavFilesPath+"\n");
//		log.debug("webdavRolesPath="+webdavRolesPath+"\n");
//		log.debug("webdavLocalRolesPath="+webdavLocalRolesPath+"\n");
//		log.debug("webdavUPortalRolesPath="+webdavUPortalRolesPath+"\n");
//		log.debug("webdavUsersPath="+webdavUsersPath+"\n");
		log.debug("ldapURL="+ldapURL+"\n");
		log.debug("ldapPort="+ldapPort+"\n");
		log.debug("ldapScope="+ldapScope+"\n");
		log.debug("ldapPrincipal="+ldapPrincipal+"\n");
		log.debug("ldapCredential="+ldapCredential+"\n");
//		log.debug("ldapUIDAttribut="+ldapUIDAttribut+"\n");
//		log.debug("homedirLDAPFilter="+homedirLDAPFilter+"\n");
//		log.debug("homedirHashType="+homedirHashType+"\n");
		
	}
	
	public String getConfigurationProperty(String property) {
		return (String)xmlPropertiesConfiguration.getProperty(property);
	}

	public void setConfigurationProperty(String property, String value) throws ConfigurationException {
		xmlPropertiesConfiguration.setProperty(property, value);
		xmlPropertiesConfiguration.save(new File("properties/configuration.xml"));
		loadConfiguration();
	}
	
	public boolean modifyConfigurationProperty(String property, String value) throws ConfigurationException {
		Object prop = xmlPropertiesConfiguration.getProperty(property);
		if (prop == null) return false;
		else {
		xmlPropertiesConfiguration.setProperty(property, value);
		xmlPropertiesConfiguration.save(new File("properties/configuration.xml"));
		loadConfiguration();
		return true;
		}
	}
	
	public Hashtable getConfiguration() {
		Hashtable configuration = new Hashtable();
		Iterator keys = xmlPropertiesConfiguration.getKeys();
		while (keys.hasNext()) {
			String key = (String)keys.next();
			Object _value = xmlPropertiesConfiguration.getProperty(key);
			if (_value == null) _value = "";
			String value = (String)_value;
			configuration.put(key, value);
		}
		return configuration;
	}
	
	/**
	 * @param calculateQuotaUsedBytesAction The calculateQuotaUsedBytesAction to set.
	 */
	public void setCalculateQuotaUsedBytesAction(
			ICommand calculateQuotaUsedBytesAction) {
		this.calculateQuotaUsedBytesAction = calculateQuotaUsedBytesAction;
	}
	/**
	 * @param getChildrenAction The getChildrenAction to set.
	 */
	public void setGetChildrenAction(ICommand getChildrenAction) {
		this.getChildrenAction = getChildrenAction;
	}
	/**
	 * @param getQuotaAvailableBytesAction The getQuotaAvailableBytesAction to set.
	 */
	public void setGetQuotaAvailableBytesAction(
			ICommand getQuotaAvailableBytesAction) {
		this.getQuotaAvailableBytesAction = getQuotaAvailableBytesAction;
	}
	/**
	 * @param getQuotaUsedBytesAction The getQuotaUsedBytesAction to set.
	 */
	public void setGetQuotaUsedBytesAction(ICommand getQuotaUsedBytesAction) {
		this.getQuotaUsedBytesAction = getQuotaUsedBytesAction;
	}
	/**
	 * @param getTreeQuotaInformationAction The getTreeQuotaInformationAction to set.
	 */
	public void setGetTreeQuotaInformationAction(
			ICommand getTreeQuotaInformationAction) {
		this.getTreeQuotaInformationAction = getTreeQuotaInformationAction;
	}
	/**
	 * @param getVirtualRootAction The getVirtualRootAction to set.
	 */
	public void setGetVirtualRootAction(ICommand getVirtualRootAction) {
		this.getVirtualRootAction = getVirtualRootAction;
	}
	/**
	 * @param patchQuotaAvailableBytesAction The patchQuotaAvailableBytesAction to set.
	 */
	public void setPatchQuotaAvailableBytesAction(
			ICommand patchQuotaAvailableBytesAction) {
		this.patchQuotaAvailableBytesAction = patchQuotaAvailableBytesAction;
	}
	/**
	 * @param patchQuotaUsedBytesAction The patchQuotaUsedBytesAction to set.
	 */
	public void setPatchQuotaUsedBytesAction(ICommand patchQuotaUsedBytesAction) {
		this.patchQuotaUsedBytesAction = patchQuotaUsedBytesAction;
	}
	/**
	 * @param removeQuotaAction The removeQuotaAction to set.
	 */
	public void setRemoveQuotaAction(ICommand removeQuotaAction) {
		this.removeQuotaAction = removeQuotaAction;
	}
	/**
	 * @param setQuotaAction The setQuotaAction to set.
	 */
	public void setSetQuotaAction(ICommand setQuotaAction) {
		this.setQuotaAction = setQuotaAction;
	}
	/**
	 * @param setVirtualRootAction The setVirtualRootAction to set.
	 */
	public void setSetVirtualRootAction(ICommand setVirtualRootAction) {
		this.setVirtualRootAction = setVirtualRootAction;
	}
	/**
	 * @param action
	 */
	public void setConnectAction(ICommand connectAction) {
		this.connectAction = connectAction;
	}
	/**
	 * @param action
	 */
	public void setCdAction(ICommand cdAction) {
		this.cdAction = cdAction;
	}
	/**
	 * @param action
	 */
	public void setExistAction(ICommand existAction) {
		this.existAction = existAction;
	}
	
//	/**
//	 * @param action
//	 */
//	public void setCreateHomedir(CreateHomedirAction createHomedirAction) {
//		this.createHomedirAction = createHomedirAction;
//	}
//	/**
//	 * @param action
//	 */
//	public void setGetNumberLDAPEntries(GetNumberLDAPEntriesAction getNumberLDAPEntriesAction) {
//		this.getNumberLDAPEntriesAction = getNumberLDAPEntriesAction;
//	}
	/**
	 * @param action
	 */
	public void setMkdirAction(MkdirAction mkdirAction) {
		this.mkdirAction = mkdirAction;
	}
	/**
	 * @param action
	 */
	public void setRmAction(RmAction rmAction) {
		this.rmAction = rmAction;
		
	}
//	/**
//	 * @param action
//	 */
//	public void setCreateInjacSpaceAction(CreateInjacSpaceAction createInjacSpaceAction) {
//		this.createInjacSpaceAction = createInjacSpaceAction;
//	}
	
	/**
	 * @param createSpaceAction The createSpaceAction to set.
	 */
	public void setCreateSpaceAction(ICommand createSpaceAction) {
		this.createSpaceAction = createSpaceAction;
	}


}// PQuotaManager
