/**
 * @author Thomas Bellembois
 * @version
 * 
 * Creation date : 21 juil. 2005
 * Last modification :
 */
package org.esupportail.injac.webdavServer.tools.commonsUtils;

import java.util.Enumeration;
import java.util.Vector;

public class CommonUtils {

	public static Enumeration convertStringToEnumeration (String stringToConvert, String separator) {
		
		Vector result = new Vector();
		
		if (stringToConvert.startsWith(separator)) stringToConvert = stringToConvert.substring(1);
		if (stringToConvert.endsWith(separator)) stringToConvert = stringToConvert.substring(0, stringToConvert.length()-1);
		
		String [] splitResult = stringToConvert.split(separator);
		
		for (int i = 0; i < splitResult.length; i++) {
			result.add(splitResult[i]);
		}// for (int i = 0; i < splitResult.length; i++)
		
		return result.elements();
		
	}// convertStringToEnumeration
	
	/**
	 * Get the parent uri of an uri
	 * @param uri to process
	 * @return the parent uri
	 */
	public static String getParentUri (String uri) {
		int indexLastSlash = uri.lastIndexOf("/");
		if (indexLastSlash == -1) return null;
		else if (indexLastSlash == 0) return "/";
		else return uri.substring(0, indexLastSlash);	
	}// getParentUri
	
	/**
	 * Get a resource name from an URI
	 * @param uri to process
	 * @return the parent uri
	 */
	public static String getResourceName (String uri) {
		int indexLastSlash = uri.lastIndexOf("/");
		if (indexLastSlash == -1) return null;
		else if (indexLastSlash == 0) return "/";
		else return uri.substring(indexLastSlash+1);	
	}// getParentUri
	
	/**
	 * Convert an array into a String
	 * @param array the array to convert
	 * @param separator the separator used to separate each element of the array in the result string
	 * @return a String
	 */
	public static String convertArrayToString (Object[] array, String separator) {
		String result = "";
		for (int i = 0; i < array.length; i++) {
			result = result + array[i].toString()+separator;
		}// for (int i = 0; i < array.length; i++)
		return result;
	}
	
	/**
	 * Convert an Enumeration into a Vector
	 * @param enumeration the Enumeration to convert
	 * @return a Vector
	 */
	public static Vector convertEnumerationToVector (Enumeration enumeration) {
		Vector result = new Vector();
		while (enumeration.hasMoreElements()) {
			Object element = (Object) enumeration.nextElement();
			result.add(element);
		}// while (enumeration.hasMoreElements())
		return result;
	}
	
}
