/**
 * @author Thomas Bellembois
 * @version
 * 
 * Creation date : 21 oct. 2005
 * Last modification :
 */
package org.esupportail.injac.webdavServer.tools.ioUtils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class CommentBufferedReader extends BufferedReader{

	private static String[] COMMENT_CHARACTER_SINGLELINE = {"#", "//"};
	private static String COMMENT_CHARACTER_BLOCK_BEGIN = "/*";
	private static String COMMENT_CHARACTER_BLOCK_END = "*/";
	
	public CommentBufferedReader(Reader in) {
		super(in);
	}

	public String readLine() throws IOException {
		String result = super.readLine();
		//System.out.println(result);
		
		while (result != null && 
				(result.startsWith(COMMENT_CHARACTER_SINGLELINE[0]) || 
				 result.startsWith(COMMENT_CHARACTER_SINGLELINE[1])
				)) {
			result = super.readLine();
			//System.out.println(result);
		}
		
		if (result != null && result.startsWith(COMMENT_CHARACTER_BLOCK_BEGIN)) {
			while ((result != null && !(result.equalsIgnoreCase(COMMENT_CHARACTER_BLOCK_END)))) {
				result = super.readLine();
				//System.out.println(result);
			}
		}
		
		if (result != null && (result.startsWith(COMMENT_CHARACTER_SINGLELINE[0]) || result.startsWith(COMMENT_CHARACTER_SINGLELINE[1]) || result.startsWith(COMMENT_CHARACTER_BLOCK_BEGIN))) return this.readLine();
		else return result;
	}
}
