/**
 * @author Thomas Bellembois
 * @version 1.0
 *
 * An _LDAPAttributes represents a list of LDAP attributes (Vector of _LDAPAtrtibute).<br/>
 *  
 * Creation date : 22 nov. 2005
 * Last modification :
 */
package org.esupportail.injac.webdavServer.tools.ldapUtils;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class _LDAPAttributes {
	
	// Vector of _LDAPAttribute
	private Vector ldapAttributeList;
	
	private Log log;
	
	public _LDAPAttributes(Vector ldapAttribute) {
		log = LogFactory.getLog(getClass().getName());
		ldapAttributeList = ldapAttribute;
	}// _LDAPAttributes
	
	public _LDAPAttributes() {
		log = LogFactory.getLog(getClass().getName());
		ldapAttributeList = new Vector();
	}// _LDAPAttributes
	
	/**
	 * Adds a new attribut with its values
	 * @param name the attribut name
	 * @param values the attribut values
	 */
	public void addLDAPAttribute(String name, Vector values) {
		log.debug("addLDAPAttribute:name="+name);
		ldapAttributeList.add(new _LDAPAttribute(name, values));
	}// addLDAPAttribute
	
	/**
	 * @return Returns the ldapAttributeList as a Vector of _LDAPAttribute
	 */
	public Vector getLdapAttributeList() {
		log.debug("getLdapAttributeList");
		return ldapAttributeList;
	}// getLdapAttributeList
	
	/**
	 * @return Returns the ldapAttribute as a _LDAPAttribute
	 */
	public _LDAPAttribute getLdapAttribute(String attributeName) {
		log.debug("getLdapAttribute:attributeName="+attributeName);
		_LDAPAttribute result = new _LDAPAttribute(attributeName,null);
		boolean attributeFound = false;
		Enumeration _ldapAttributeList = ldapAttributeList.elements();
		while (_ldapAttributeList.hasMoreElements() && !attributeFound) {
			_LDAPAttribute ldapAttribute = (_LDAPAttribute) _ldapAttributeList.nextElement();
			log.debug("getLdapAttribute:ldapAttribute="+ldapAttribute.getName());
			if (ldapAttribute.getName().equalsIgnoreCase(attributeName)) {
				result = ldapAttribute;
				attributeFound = true;
			}// if (ldapAttribute.getName().equalsIgnoreCase(attributeName))
			log.debug("getLdapAttribute:attributeFound="+attributeFound);
		}// while (_ldapAttributeList.hasMoreElements())		
		if (attributeFound){
			log.debug("getLdapAttribute:result="+result);
		} else {
			log.debug("getLdapAttribute:result=null");
		}
		return result;
	}// getLdapAttributeList
	
	/**
	 * Returns a String representation of the attributes
	 */
	public String toString() {
		String result = "";
		Enumeration _ldapAttributeList = ldapAttributeList.elements();
		while (_ldapAttributeList.hasMoreElements()) {
			result = result + " : " + ((_LDAPAttribute)(_ldapAttributeList.nextElement())).toString();
		}// while (_ldapAttributeList.hasMoreElements())
		return result.substring(1); // removing the leading :
	}// toString
	
}//LdapAtributes
