/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.io.InputStream;
import java.util.HashMap;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.model.DRLOutput;
import org.drools.decisiontable.model.Package;
import org.drools.decisiontable.parser.DecisionTableParser;
import org.drools.decisiontable.parser.DefaultRuleSheetListener;
import org.drools.decisiontable.parser.RuleSheetListener;
import org.drools.decisiontable.parser.xls.ExcelParser;

public class SpreadsheetCompiler {
    public String compile(InputStream inputStream, InputType inputType) {
        return this.compile(inputStream, inputType, new DefaultRuleSheetListener());
    }

    public String compile(InputStream inputStream, InputType inputType, RuleSheetListener ruleSheetListener) {
        DecisionTableParser decisionTableParser = inputType.createParser(ruleSheetListener);
        decisionTableParser.parseFile(inputStream);
        Package package_ = ruleSheetListener.getRuleSet();
        DRLOutput dRLOutput = new DRLOutput();
        package_.renderDRL(dRLOutput);
        return dRLOutput.getDRL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String compile(String string, InputType inputType) {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        try {
            String string2;
            String string3 = string2 = this.compile(inputStream, inputType);
            return string3;
        }
        finally {
            this.closeStream(inputStream);
        }
    }

    public String compile(InputStream inputStream, String string) {
        RuleSheetListener ruleSheetListener = this.getRuleSheetListener(inputStream, string);
        Package package_ = ruleSheetListener.getRuleSet();
        DRLOutput dRLOutput = new DRLOutput();
        package_.renderDRL(dRLOutput);
        return dRLOutput.getDRL();
    }

    private RuleSheetListener getRuleSheetListener(InputStream inputStream, String string) {
        DefaultRuleSheetListener defaultRuleSheetListener = new DefaultRuleSheetListener();
        HashMap<String, DefaultRuleSheetListener> hashMap = new HashMap<String, DefaultRuleSheetListener>();
        hashMap.put(string, defaultRuleSheetListener);
        ExcelParser excelParser = new ExcelParser(hashMap);
        excelParser.parseFile(inputStream);
        return defaultRuleSheetListener;
    }

    private void closeStream(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            System.err.print("WARNING: Wasn't able to correctly close stream for decision table. " + exception.getMessage());
        }
    }
}

