/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.model;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.drools.decisiontable.model.Condition;
import org.drools.decisiontable.model.Consequence;
import org.drools.decisiontable.model.DRLElement;
import org.drools.decisiontable.model.DRLJavaEmitter;
import org.drools.decisiontable.model.DRLOutput;
import org.drools.decisiontable.model.Duration;

public class Rule
extends DRLElement
implements DRLJavaEmitter {
    private static final int MAX_ROWS = 65535;
    private Integer _salience;
    private String _name;
    private Duration _duration;
    private String _description;
    private String _noLoop;
    private String _activationGroup;
    private String _agendaGroup;
    private List _lhs;
    private List _rhs;
    private int _spreadsheetRow;

    public Rule(String string, Integer n, int n2) {
        this._name = string;
        this._salience = n;
        this._description = "";
        this._lhs = new LinkedList();
        this._rhs = new LinkedList();
        this._spreadsheetRow = n2;
    }

    public void addCondition(Condition condition) {
        this._lhs.add(condition);
    }

    public void addConsequence(Consequence consequence) {
        this._rhs.add(consequence);
    }

    public void renderDRL(DRLOutput dRLOutput) {
        if (this.isCommented()) {
            dRLOutput.writeLine("#" + this.getComment());
        }
        dRLOutput.writeLine("rule \"" + this._name + "\"");
        if (this._description != null) {
            dRLOutput.writeLine("\t" + this._description);
        }
        if (this._salience != null) {
            dRLOutput.writeLine("\tsalience " + this._salience);
        }
        if (this._activationGroup != null) {
            dRLOutput.writeLine("\tactivation-group \"" + this._activationGroup + "\"");
        }
        if (this._agendaGroup != null) {
            dRLOutput.writeLine("\tagenda-group " + this._agendaGroup);
        }
        if (this._noLoop != null) {
            dRLOutput.writeLine("\tno-loop " + this._noLoop);
        }
        if (this._duration != null) {
            dRLOutput.writeLine("\tduration " + this._duration);
        }
        dRLOutput.writeLine("\twhen");
        this.renderDRL(this._lhs, dRLOutput);
        dRLOutput.writeLine("\tthen");
        this.renderDRL(this._rhs, dRLOutput);
        dRLOutput.writeLine("end\n");
    }

    private void renderDRL(List list, DRLOutput dRLOutput) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DRLJavaEmitter dRLJavaEmitter = (DRLJavaEmitter)iterator.next();
            dRLJavaEmitter.renderDRL(dRLOutput);
        }
    }

    public static int calcSalience(int n) {
        if (n > 65535) {
            throw new IllegalArgumentException("That row number is above the max: 65535");
        }
        return 65535 - n;
    }

    public static String convertColNumToColName(int n) {
        String string;
        int n2 = n / 26;
        int n3 = n % 26;
        if (n2 == 0) {
            byte[] byArray = new byte[]{(byte)(n3 + 65)};
            string = Rule.byteToString(byArray);
        } else {
            byte[] byArray = new byte[]{(byte)(n2 - 1 + 65)};
            byte[] byArray2 = new byte[]{(byte)(n3 + 65)};
            String string2 = Rule.byteToString(byArray);
            String string3 = Rule.byteToString(byArray2);
            string = string2 + string3;
        }
        return string;
    }

    private static String byteToString(byte[] byArray) {
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unable to convert char to string.", unsupportedEncodingException);
        }
    }

    public List getConditions() {
        return this._lhs;
    }

    public List getConsequences() {
        return this._rhs;
    }

    public void setSalience(Integer n) {
        this._salience = n;
    }

    public Integer getSalience() {
        return this._salience;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getName() {
        return this._name;
    }

    public void setDescription(String string) {
        this._description = string;
    }

    public void appendDescription(String string) {
        this._description = this._description + string;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDuration(Duration duration) {
        this._duration = duration;
    }

    public String getDuration() {
        return this._duration.getSnippet();
    }

    public void setActivationGroup(String string) {
        this._activationGroup = string;
    }

    public String getActivationGroup() {
        return this._activationGroup;
    }

    public String getAgendaGroup() {
        return this._agendaGroup;
    }

    public void setAgendaGroup(String string) {
        this._agendaGroup = string;
    }

    public void setNoLoop(String string) {
        this._noLoop = string;
    }

    public int getSpreadsheetRowNumber() {
        return this._spreadsheetRow;
    }
}

