/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser.csv;

import java.util.ArrayList;
import java.util.List;

public class CsvLineParser {
    private ICsvParser lineParser = new CsvParserImpl();

    public List parse(CharSequence charSequence) {
        return this.lineParser.parse(((Object)charSequence).toString());
    }

    static class CsvParserImpl
    implements ICsvParser {
        public static final char DEFAULT_SEP = ',';
        protected List list = new ArrayList();
        protected char fieldSep;

        public CsvParserImpl() {
            this(',');
        }

        public CsvParserImpl(char c) {
            this.fieldSep = c;
        }

        public List parse(String string) {
            StringBuffer stringBuffer = new StringBuffer();
            this.list.clear();
            int n = 0;
            if (string.length() == 0) {
                this.list.add(string);
                return this.list;
            }
            do {
                stringBuffer.setLength(0);
                if (n < string.length() && string.charAt(n) == '\"') {
                    ++n;
                    n = this.advQuoted(string, stringBuffer, n);
                } else {
                    n = this.advPlain(string, stringBuffer, n);
                }
                this.list.add(stringBuffer.toString());
            } while (++n < string.length());
            return this.list;
        }

        protected int advQuoted(String string, StringBuffer stringBuffer, int n) {
            int n2;
            int n3 = string.length();
            for (n2 = n; n2 < n3; ++n2) {
                if (string.charAt(n2) == '\"' && n2 + 1 < n3) {
                    if (string.charAt(n2 + 1) == '\"') {
                        ++n2;
                    } else if (string.charAt(n2 + 1) == this.fieldSep) {
                        ++n2;
                        break;
                    }
                } else if (string.charAt(n2) == '\"' && n2 + 1 == n3) break;
                stringBuffer.append(string.charAt(n2));
            }
            return n2;
        }

        protected int advPlain(String string, StringBuffer stringBuffer, int n) {
            int n2 = string.indexOf(this.fieldSep, n);
            if (n2 == -1) {
                stringBuffer.append(string.substring(n));
                return string.length();
            }
            stringBuffer.append(string.substring(n, n2));
            return n2;
        }
    }

    static interface ICsvParser {
        public List parse(String var1);
    }
}

